package ch.codeblock.qrinvoice;

import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.validation.ValidationException;
import ch.codeblock.qrinvoice.paymentpart.PaymentPartWriter;

import java.util.Locale;

public class QrInvoicePaymentPartCreator {
    private QrInvoice qrInvoice;
    private PageSize pageSize;
    private OutputFormat outputFormat;
    private Locale locale;

    private QrInvoicePaymentPartCreator(){
    }
    
    public static QrInvoicePaymentPartCreator create() {
        return new QrInvoicePaymentPartCreator();
    }
    
    public QrInvoicePaymentPartCreator qrInvoice(final QrInvoice qrInvoice) {
        this.qrInvoice = qrInvoice;
        return this;
    }

    public QrInvoicePaymentPartCreator outputFormat(final OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    public QrInvoicePaymentPartCreator pageSize(final PageSize pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public QrInvoicePaymentPartCreator locale(final Locale locale) {
        if(!QrInvoiceSpec.SUPPORTED_LOCALES.contains(locale)) {
            throw new ValidationException("Unsupported locale '" + locale + "'");
        }
        this.locale = locale;
        return this;
    }

    public QrInvoicePaymentPartCreator inGerman() {
        this.locale(Locale.GERMAN);
        return this;
    }
    public QrInvoicePaymentPartCreator inFrench() {
        this.locale(Locale.FRENCH);
        return this;
    }
    public QrInvoicePaymentPartCreator inEnglish() {
        this.locale(Locale.ENGLISH);
        return this;
    }
    public QrInvoicePaymentPartCreator inItalian() {
        this.locale(Locale.ITALIAN);
        return this;
    }

    public byte[] createPaymentPart() {
        // apply defaults, if not explicitely set
        if(pageSize == null) {
            pageSize = PageSize.A4;
        }
        if(outputFormat == null) {
            outputFormat = OutputFormat.PDF;
        }
        if(locale == null) {
            locale = Locale.GERMAN;
        }
        return new PaymentPartWriter().write(pageSize, outputFormat, locale, qrInvoice);
    }

}
