package ch.codeblock.qrinvoice;

import ch.codeblock.qrinvoice.layout.Dimension;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Currency;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;

import static java.util.Arrays.asList;
import static java.util.Locale.*;

/**
 * Dimensions are in Millimeter
 */
public class QrInvoiceSpec {
    /**
     * According to the spec 3.2.5 - v1.0
     */
    public static final String ELEMENT_SEPARATOR = "\r\n";
    public static final Pattern ELEMENT_SEPARATOR_PATTERN = Pattern.compile("\\r\\n|\\n|\\r");
    /**
     * Swiss Payments Code
     */
    public static final String QR_TYPE = "SPC";
    /**
     * Version 1.00
     */
    public static final String VERSION = "0100";
    /**
     * Coding 1 = Latin Character Set
     */
    public static final byte CODING_TPYE = 1;
    /**
     * Only the latin character set is supported - according to the spec 3.2.1 - v1.0 
     */
    public static final Charset ENCODING = Charset.forName("ISO-8859-15");

    /**
     * Decimal separator according to the spec 2.5.4 - v1.0
     */
    public static final char AMOUNT_DECIMAL_FORMAT_DECIMAL_SEPARATOR = '.';
    /**
     * Thousands separator according to the spec 2.5.4 - v1.0
     */
    public static final char AMOUNT_DECIMAL_FORMAT_GROUPING_SEPARATOR = ' ';
    /**
     * Format according to {@link ch.codeblock.qrinvoice.model.PaymentAmountInformation#amount}
     */
    public static final String AMOUNT_DECIMAL_FORMAT_QRCODE = "#######.##";
    /**
     * Format according to the spec 2.5.4 - v1.0
     */
    public static final String AMOUNT_DECIMAL_FORMAT_PRINT = "#,###,###.##";
    public static final BigDecimal AMOUNT_MIN = BigDecimal.ZERO;
    public static final BigDecimal AMOUNT_MAX = BigDecimal.valueOf(999999999.99);
    public static final String DATE_FORMAT_PRINT = "dd.MM.yyyy";

    public static final Set<Locale> SUPPORTED_LOCALES = new HashSet<>(asList(GERMAN, FRENCH, ENGLISH, ITALIAN));
    public static final Currency CHF = Currency.getInstance("CHF");
    public static final Currency EUR = Currency.getInstance("EUR");
    public static final Set<Currency> SUPPORTED_CURRENCIES = new HashSet<>(asList(CHF, EUR));
    
    public static final String COUNTRY_CODE_SWITZERLAND = "CH";
    public static final String COUNTRY_CODE_LIECHTENSTEIN = "LI";
    public static final Set<String> SUPPORTED_IBAN_COUNTRIES = new HashSet<>(asList(COUNTRY_CODE_SWITZERLAND, COUNTRY_CODE_LIECHTENSTEIN));
    /** Alternative scheme parameters - Can be currently delivered a maximum of two times. */
    public static final int MAX_ALT_PMT = 2;
    
    public static final Dimension<Integer> QR_CODE_SIZE = new Dimension<>(46, 46);
    public static final Dimension<Integer> QR_CODE_LOGO_SIZE = new Dimension<>(7, 7);
    public static final int QUIET_SPACE = 5; // min 5mm

    public static final float BOX_CORNER_LENGTH = 3.5f;

    public static final Dimension<Integer> DEBTOR_FIELD = new Dimension<>(65, 25);
    public static final Dimension<Integer> AMOUNT_FIELD = new Dimension<>(40, 15);
    public static final Dimension<Integer> AMOUNT_SECTION = new Dimension<>(QR_CODE_SIZE.getWidth() + QUIET_SPACE, AMOUNT_FIELD.getHeight() + 7);
}
