package ch.codeblock.qrinvoice.layout;

import ch.codeblock.qrinvoice.util.NumberUtils;

public class Point<T extends Number> {
    private final T x;
    private final T y;

    public Point(final T x, final T y) {
        this.x = x;
        this.y = y;
    }

    public T getX() {
        return x;
    }

    public T getY() {
        return y;
    }

    public Point<T> move(final Point<T> offset) {
        return move(offset.getX(), offset.getY());
    }

    public Point<T> move(final T offsetX, final T offsetY) {
        return new Point<T>(NumberUtils.add(x,offsetX), NumberUtils.add(x,offsetY));
    }
}

