package ch.codeblock.qrinvoice.model;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Currency;
import java.util.Objects;

/**
 * <p>From the specification v1.0</p>
 * <table border="1" summary="Excerpt from the specification">
 * <tr><th>Language</th><th>General Definition</th><th>Field Definition</th></tr>
 * <tr><td>EN</td><td>Payment amount information</td><td>Mandatory data group</td></tr>
 * <tr><td>DE</td><td>Zahlbetragsinformation</td><td>Obligatorische Datengruppe</td></tr>
 * <tr><td>FR</td><td>Information sur le montant du paiement</td><td>Groupe de données obligatoire</td></tr>
 * <tr><td>IT</td><td>Informazioni sull’importo da pagare</td><td>Gruppo di dati obbligatorio<br> </td></tr>
 * </table>
 * <p>Data Structure Element</p>
 * <pre>
 * QRCH
 * +CcyAmtDate
 * </pre>
 */
public class PaymentAmountInformation {
    /**
     * <p>From the specification v1.0</p>
     * <table border="1" summary="Excerpt from the specification">
     * <tr><th>Language</th><th>General Definition</th><th>Field Definition</th></tr>
     * <tr><td>EN</td><td>Amount<br>The payment amount</td><td>The amount element is to be entered without leading zeroes, including decimal separators and two decimal places.<br><br>Decimal, maximum 12-digits permitted, including decimal separators. Only decimal points (""."") are permitted as decimal separators.</td></tr>
     * <tr><td>DE</td><td>Betrag<br>Betrag der Zahlung</td><td>Das Element ist ohne führende Nullen, inklusive Dezimaltrenn zeichen und zwei Nachkommastellen, anzugeben.<br>Dezimal, max. 12 Stellen zulässig, inklusive Dezimaltrennzeichen.<br>Als Dezimaltrennzeichen ist nur das Punktzeichen («.») zulässig.</td></tr>
     * <tr><td>FR</td><td>Montant<br>Montant du paiement</td><td>L'élément est à indiquer sans zéros de tête y compris séparateur décimal et deux décimales.<br>Décimal, 12 positions au maximum admises, y compris séparateur décimal. Seul le point («.») est admis comme séparateur décimal.</td></tr>
     * <tr><td>IT</td><td>Importo<br>Importo del pagamento</td><td>L’elemento deve essere indicato senza zeri antecedenti, con il segno di separazione dei decimali e due cifre dopo la virgola.<br>Per i decimali, ammessi al massimo 12 caratteri, incluso il segno di separazione.<br>Come segno di separazione dei decimali<br>è ammesso il punto (.).</td></tr>
     * </table>
     * <p>Status: {@link Status#OPTIONAL}</p>
     * <p>Data Structure Element</p>
     * <pre>
     * QRCH
     * +CcyAmtDate
     * ++Amt
     * </pre>
     */
    private BigDecimal amount;
    /**
     * <p>From the specification v1.0</p>
     * <table border="1" summary="Excerpt from the specification">
     * <tr><th>Language</th><th>General Definition</th><th>Field Definition</th></tr>
     * <tr><td>EN</td><td>Currency<br>The payment currency, 3-digit alphanumeric currency code according to ISO 4217</td><td>Only CHF and EUR are permitted.</td></tr>
     * <tr><td>DE</td><td>Währung<br>Währung der Zahlung, dreistelliger alphabetischer Währungscode gemäss ISO 4217</td><td>Nur CHF und EUR zugelassen.</td></tr>
     * <tr><td>FR</td><td>Monnaie<br>Monnaie du paiement, code monétaire alphabétique à trois positions selon ISO 4217</td><td>Seuls CHF et EUR sont admis.</td></tr>
     * <tr><td>IT</td><td>Valuta<br>Valuta del pagamento, codice valuta alfanumerico a 3 caratteri secondo ISO 4217</td><td>Supportati solo CHF e EUR.</td></tr>
     * </table>
     * <p>Status: {@link Status#MANDATORY}</p>
     * <p>Data Structure Element</p>
     * <pre>
     * QRCH
     * +CcyAmtDate
     * ++Ccy
     * </pre>
     */
    private Currency currency;
    /**
     * <p>From the specification v1.0</p>
     * <table border="1" summary="Excerpt from the specification">
     * <tr><th>Language</th><th>General Definition</th><th>Field Definition</th></tr>
     * <tr><td>EN</td><td>Date<br>Due date<br>Due date on which, according to the biller, the payment should be paid, at the latest (according to the payment conditions)</td><td>Ten-digit; if delivered, the date must be entered in the format<br><br>YYYY-MM-DD.</td></tr>
     * <tr><td>DE</td><td>Datum<br>Zahlbar bis Fälligkeitsdatum, an dem gemäss Rechnungssteller die Zahlung spätestens bezahlt sein soll (gemäss Zahlungskonditionen)</td><td>Zehnstellig; wenn geliefert, muss das Datum im Format YYYY-MM-DD angegeben werden.</td></tr>
     * <tr><td>FR</td><td>Date<br>À payer jusqu'au Date d'échéance à laquelle le paiement doit être réglé au plus tard selon l'émet- teur de la facture (selon conditions de paiement)</td><td>Dix positions; si elle est livrée, la date doit être indiquée dans le format YYYY-MM-DD.</td></tr>
     * <tr><td>IT</td><td>Data<br>Da pagare entro il<br>Data di scadenza entro la quale, secondo il mittente della fattura deve essere effettuato al più tardi il pagamento (in conformità alle condizioni di pagamento)</td><td>10 caratteri; se presente, la data deve essere indicata nel formato YYYY-MM-DD.</td></tr>
     * </table>
     * <p>Status: {@link Status#OPTIONAL}</p>
     * <p>Data Structure Element</p>
     * <pre>
     * QRCH
     * +CcyAmtDate
     * ++ReqdExctnDt
     * </pre>
     */
    private LocalDate date;

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(final BigDecimal amount) {
        this.amount = amount;
    }

    public Currency getCurrency() {
        return currency;
    }

    public void setCurrency(final Currency currency) {
        this.currency = currency;
    }

    public LocalDate getDate() {
        return date;
    }

    public void setDate(final LocalDate date) {
        this.date = date;
    }

    @Override
    public String toString() {
        return "PaymentAmountInformation{" +
                "amount=" + amount +
                ", currency=" + currency +
                ", date=" + date +
                '}';
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final PaymentAmountInformation that = (PaymentAmountInformation) o;
        return Objects.equals(amount, that.amount) &&
                Objects.equals(currency, that.currency) &&
                Objects.equals(date, that.date);
    }

    @Override
    public int hashCode() {
        return Objects.hash(amount, currency, date);
    }
}
