package ch.codeblock.qrinvoice.model;

public enum Status {
    /**
     * <p>Mandatory, must always be delivered and filled.</p>
     * <table border="1" summary="Excerpt from the specification">
     *     <tr><th>Language</th><th>General Definition</th></tr>
     *     <tr><td>EN</td><td>Field must mandatorily be delivered filled</td></tr>
     *     <tr><td>DE</td><td>Feld muss zwingend befüllt geliefert werden.</td></tr>
     *     <tr><td>FR</td><td>Le champ doit obligatoirement être livré dûment rempli.</td></tr>
     *     <tr><td>IT</td><td>Campo da inviare obbligatoriamente compilato. </td></tr>
     * </table>
     */
    MANDATORY,
    /**
     * <p>Mandatory if superordinate data group is filled</p>
     * <table border="1" summary="Excerpt from the specification">
     *     <tr><th>Language</th><th>General Definition</th></tr>
     *     <tr><td>EN</td><td>Field must mandatorily be filled if the superordinate optional data group is filled.</td></tr>
     *     <tr><td>DE</td><td>Feld muss zwingend befüllt werden, wenn die übergeordnete optionale Datengruppe befüllt ist.</td></tr>
     *     <tr><td>FR</td><td>Le champ doit être rempli impérativement lorsque le groupe de données optionnel supérieur est rempli.</td></tr>
     *     <tr><td>IT</td><td>Campo da inviare obbligatoriamente compilato, se il gruppo di dati opzionale di ordine superiore è compilato.</td></tr>
     * </table>
     */
    DEPENDENT,
    /**
     * <p>Mandatory field with optional content</p>
     * <table border="1" summary="Excerpt from the specification">
     *     <tr><th>Language</th><th>General Definition</th></tr>
     *     <tr><td>EN</td><td>Field must mandatorily be delivered, but not necessarily filled (can be empty).</td></tr>
     *     <tr><td>DE</td><td>Feld muss zwingend geliefert, aber nicht zwingend befüllt werden (kann leer sein).</td></tr>
     *     <tr><td>FR</td><td>Le champ doit être livré impérativement, mais il ne doit pas être rempli impérativement (il peut être vide).</td></tr>
     *     <tr><td>IT</td><td>Campo da inviare, ma non da compilare obbligatoriamente (può essere vuoto).</td></tr>
     * </table>
     */
    OPTIONAL,
    /**
     * <p>Optional field</p>
     * <table border="1" summary="Excerpt from the specification">
     *     <tr><th>Language</th><th>General Definition</th></tr>
     *     <tr><td>EN</td><td>Field does not necessarily have to be delivered</td></tr>
     *     <tr><td>DE</td><td>Feld muss nicht geliefert werden.</td></tr>
     *     <tr><td>FR</td><td>Le champ ne doit pas être livré.</td></tr>
     *     <tr><td>IT</td><td>Campo che non deve essere necessariamente inviato</td></tr>
     * </table>
     */
    ADDITIONAL
}
