package ch.codeblock.qrinvoice.model;

import ch.codeblock.qrinvoice.QrInvoiceSpec;
import ch.codeblock.qrinvoice.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;

import static ch.codeblock.qrinvoice.util.StringUtils.emptyStringAsNull;

public final class SwissPaymentsCode {
    // Header
    private String qrType;
    private String version;
    private String coding;

    // CdtrInf
    private String iban;
    private String crName;
    private String crStrtNm;
    private String crBldgNb;
    private String crPstCd;
    private String crTwnNm;
    private String crCtry;

    // UltmtCdtr
    private String ucrName;
    private String ucrStrtNm;
    private String ucrBldgNb;
    private String ucrPstCd;
    private String ucrTwnNm;
    private String ucrCtry;

    // CcyAmtDate
    private String amt;
    private String ccy;
    private String reqdExctnDt;

    // UltmtDbtr
    private String udName;
    private String udStrtNm;
    private String udBldgNb;
    private String udPstCd;
    private String udTwnNm;
    private String udCtry;

    // RmtInf
    private String tp;
    private String ref;
    private String ustrd;

    // AltPmtInf
    private List<String> altPmts;

    public String getQrType() {
        return qrType;
    }

    public void setQrType(final String qrType) {
        this.qrType = qrType;
    }

    public String getCoding() {
        return coding;
    }

    public void setCoding(final String coding) {
        this.coding = coding;
    }

    public String getIban() {
        return iban;
    }

    public void setIban(final String iban) {
        this.iban = iban;
    }

    public String getCrName() {
        return crName;
    }

    public void setCrName(final String crName) {
        this.crName = crName;
    }

    public String getCrStrtNm() {
        return crStrtNm;
    }

    public void setCrStrtNm(final String crStrtNm) {
        this.crStrtNm = crStrtNm;
    }

    public String getCrBldgNb() {
        return crBldgNb;
    }

    public void setCrBldgNb(final String crBldgNb) {
        this.crBldgNb = crBldgNb;
    }

    public String getCrPstCd() {
        return crPstCd;
    }

    public void setCrPstCd(final String crPstCd) {
        this.crPstCd = crPstCd;
    }

    public String getCrTwnNm() {
        return crTwnNm;
    }

    public void setCrTwnNm(final String crTwnNm) {
        this.crTwnNm = crTwnNm;
    }

    public String getCrCtry() {
        return crCtry;
    }

    public void setCrCtry(final String crCtry) {
        this.crCtry = crCtry;
    }

    public String getUcrName() {
        return ucrName;
    }

    public void setUcrName(final String ucrName) {
        this.ucrName = ucrName;
    }

    public String getUcrStrtNm() {
        return ucrStrtNm;
    }

    public void setUcrStrtNm(final String ucrStrtNm) {
        this.ucrStrtNm = ucrStrtNm;
    }

    public String getUcrBldgNb() {
        return ucrBldgNb;
    }

    public void setUcrBldgNb(final String ucrBldgNb) {
        this.ucrBldgNb = ucrBldgNb;
    }

    public String getUcrPstCd() {
        return ucrPstCd;
    }

    public void setUcrPstCd(final String ucrPstCd) {
        this.ucrPstCd = ucrPstCd;
    }

    public String getUcrTwnNm() {
        return ucrTwnNm;
    }

    public void setUcrTwnNm(final String ucrTwnNm) {
        this.ucrTwnNm = ucrTwnNm;
    }

    public String getUcrCtry() {
        return ucrCtry;
    }

    public void setUcrCtry(final String ucrCtry) {
        this.ucrCtry = ucrCtry;
    }

    public String getAmt() {
        return amt;
    }

    public void setAmt(final String amt) {
        this.amt = amt;
    }

    public String getCcy() {
        return ccy;
    }

    public void setCcy(final String ccy) {
        this.ccy = ccy;
    }

    public String getReqdExctnDt() {
        return reqdExctnDt;
    }

    public void setReqdExctnDt(final String reqdExctnDt) {
        this.reqdExctnDt = reqdExctnDt;
    }

    public String getUdName() {
        return udName;
    }

    public void setUdName(final String udName) {
        this.udName = udName;
    }

    public String getUdStrtNm() {
        return udStrtNm;
    }

    public void setUdStrtNm(final String udStrtNm) {
        this.udStrtNm = udStrtNm;
    }

    public String getUdBldgNb() {
        return udBldgNb;
    }

    public void setUdBldgNb(final String udBldgNb) {
        this.udBldgNb = udBldgNb;
    }

    public String getUdPstCd() {
        return udPstCd;
    }

    public void setUdPstCd(final String udPstCd) {
        this.udPstCd = udPstCd;
    }

    public String getUdTwnNm() {
        return udTwnNm;
    }

    public void setUdTwnNm(final String udTwnNm) {
        this.udTwnNm = udTwnNm;
    }

    public String getUdCtry() {
        return udCtry;
    }

    public void setUdCtry(final String udCtry) {
        this.udCtry = udCtry;
    }

    public String getTp() {
        return tp;
    }

    public void setTp(final String tp) {
        this.tp = tp;
    }

    public String getRef() {
        return ref;
    }

    public void setRef(final String ref) {
        this.ref = ref;
    }

    public String getUstrd() {
        return ustrd;
    }

    public void setUstrd(final String ustrd) {
        this.ustrd = ustrd;
    }

    public List<String> getAltPmts() {
        return altPmts;
    }

    public void setAltPmts(final List<String> altPmts) {
        this.altPmts = altPmts;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(final String version) {
        this.version = version;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final SwissPaymentsCode that = (SwissPaymentsCode) o;
        return Objects.equals(qrType, that.qrType) &&
                Objects.equals(version, that.version) &&
                Objects.equals(coding, that.coding) &&
                Objects.equals(iban, that.iban) &&
                Objects.equals(crName, that.crName) &&
                Objects.equals(crStrtNm, that.crStrtNm) &&
                Objects.equals(crBldgNb, that.crBldgNb) &&
                Objects.equals(crPstCd, that.crPstCd) &&
                Objects.equals(crTwnNm, that.crTwnNm) &&
                Objects.equals(crCtry, that.crCtry) &&
                Objects.equals(ucrName, that.ucrName) &&
                Objects.equals(ucrStrtNm, that.ucrStrtNm) &&
                Objects.equals(ucrBldgNb, that.ucrBldgNb) &&
                Objects.equals(ucrPstCd, that.ucrPstCd) &&
                Objects.equals(ucrTwnNm, that.ucrTwnNm) &&
                Objects.equals(ucrCtry, that.ucrCtry) &&
                Objects.equals(amt, that.amt) &&
                Objects.equals(ccy, that.ccy) &&
                Objects.equals(reqdExctnDt, that.reqdExctnDt) &&
                Objects.equals(udName, that.udName) &&
                Objects.equals(udStrtNm, that.udStrtNm) &&
                Objects.equals(udBldgNb, that.udBldgNb) &&
                Objects.equals(udPstCd, that.udPstCd) &&
                Objects.equals(udTwnNm, that.udTwnNm) &&
                Objects.equals(udCtry, that.udCtry) &&
                Objects.equals(tp, that.tp) &&
                Objects.equals(ref, that.ref) &&
                Objects.equals(ustrd, that.ustrd) &&
                Objects.equals(altPmts, that.altPmts);
    }

    @Override
    public int hashCode() {
        return Objects.hash(qrType, version, coding, iban, crName, crStrtNm, crBldgNb, crPstCd, crTwnNm, crCtry, ucrName, ucrStrtNm, ucrBldgNb, ucrPstCd, ucrTwnNm, ucrCtry, amt, ccy, reqdExctnDt, udName, udStrtNm, udBldgNb, udPstCd, udTwnNm, udCtry, tp, ref, ustrd, altPmts);
    }

    public String toSwissPaymentsCodeString() {
        StringBuilder sb = new StringBuilder();

        appendField(sb, qrType);
        appendField(sb, version);
        appendField(sb, coding);
        appendField(sb, iban);
        appendField(sb, crName);
        appendField(sb, crStrtNm);
        appendField(sb, crBldgNb);
        appendField(sb, crPstCd);
        appendField(sb, crTwnNm);
        appendField(sb, crCtry);
        appendField(sb, ucrName);
        appendField(sb, ucrStrtNm);
        appendField(sb, ucrBldgNb);
        appendField(sb, ucrPstCd);
        appendField(sb, ucrTwnNm);
        appendField(sb, ucrCtry);
        appendField(sb, amt);
        appendField(sb, ccy);
        appendField(sb, reqdExctnDt);
        appendField(sb, udName);
        appendField(sb, udStrtNm);
        appendField(sb, udBldgNb);
        appendField(sb, udPstCd);
        appendField(sb, udTwnNm);
        appendField(sb, udCtry);
        appendField(sb, tp);
        appendField(sb, ref);
        appendField(sb, ustrd);
        if(CollectionUtils.isNotEmpty(altPmts)) {
            altPmts.forEach(altPmt -> appendField(sb, altPmt));
        }

        return sb.toString();
    }
    
    private StringBuilder appendField(StringBuilder sb, String value) {
        if(value != null) {
            sb.append(value);
        }
        sb.append(QrInvoiceSpec.ELEMENT_SEPARATOR);
        return sb;
    }

    @Override
    public String toString() {
        return "SwissPaymentsCode{" +
                "qrType='" + qrType + '\'' +
                ", version='" + version + '\'' +
                ", coding='" + coding + '\'' +
                ", iban='" + iban + '\'' +
                ", crName='" + crName + '\'' +
                ", crStrtNm='" + crStrtNm + '\'' +
                ", crBldgNb='" + crBldgNb + '\'' +
                ", crPstCd='" + crPstCd + '\'' +
                ", crTwnNm='" + crTwnNm + '\'' +
                ", crCtry='" + crCtry + '\'' +
                ", ucrName='" + ucrName + '\'' +
                ", ucrStrtNm='" + ucrStrtNm + '\'' +
                ", ucrBldgNb='" + ucrBldgNb + '\'' +
                ", ucrPstCd='" + ucrPstCd + '\'' +
                ", ucrTwnNm='" + ucrTwnNm + '\'' +
                ", ucrCtry='" + ucrCtry + '\'' +
                ", amt='" + amt + '\'' +
                ", ccy='" + ccy + '\'' +
                ", reqdExctnDt='" + reqdExctnDt + '\'' +
                ", udName='" + udName + '\'' +
                ", udStrtNm='" + udStrtNm + '\'' +
                ", udBldgNb='" + udBldgNb + '\'' +
                ", udPstCd='" + udPstCd + '\'' +
                ", udTwnNm='" + udTwnNm + '\'' +
                ", udCtry='" + udCtry + '\'' +
                ", tp='" + tp + '\'' +
                ", ref='" + ref + '\'' +
                ", ustrd='" + ustrd + '\'' +
                ", altPmts='" + altPmts + '\'' +
                '}';
    }

    /**
     * 
     * @param swissPaymentsCode The Swiss Payments Code String
     * @return the parse SwissPaymentsCode instance
     * @throws ParseException in case of any parsing exceptions or unexpected problems
     */
    public static SwissPaymentsCode parse(String swissPaymentsCode) {
        try {
            return internalParse(swissPaymentsCode);
        } catch (ParseException parseException) {
            throw parseException;
        } catch (Exception e) {
            throw new ParseException("Unexpected exception occured during Swiss Payment Code Parsing", e);
        }
    }

    private static SwissPaymentsCode internalParse(final String swissPaymentsCode) {
        if(swissPaymentsCode == null) {
            throw new ParseException("Encountered unexpected null instead of SwissPaymentsCode String");
        }

        final Scanner scanner = new Scanner(swissPaymentsCode).useDelimiter(QrInvoiceSpec.ELEMENT_SEPARATOR_PATTERN);

        final SwissPaymentsCode spc = new SwissPaymentsCode();

        // Header
        spc.setQrType(read(scanner));
        if(!QrInvoiceSpec.QR_TYPE.equals(spc.getQrType())) {
            throw new ParseException("QR-Type '" + QrInvoiceSpec.QR_TYPE + "' expected, but '" + spc.getQrType() + "' encountered");
        }

        spc.setVersion(read(scanner));
        spc.setCoding(read(scanner));

        // CdtrInf
        spc.setIban(read(scanner));

        // Cdtr
        spc.setCrName(read(scanner));
        spc.setCrStrtNm(read(scanner));
        spc.setCrBldgNb(read(scanner));
        spc.setCrPstCd(read(scanner));
        spc.setCrTwnNm(read(scanner));
        spc.setCrCtry(read(scanner));

        // UltmtCdtr
        spc.setUcrName(read(scanner));
        spc.setUcrStrtNm(read(scanner));
        spc.setUcrBldgNb(read(scanner));
        spc.setUcrPstCd(read(scanner));
        spc.setUcrTwnNm(read(scanner));
        spc.setUcrCtry(read(scanner));

        // CcyAmtDate
        spc.setAmt(read(scanner));
        spc.setCcy(read(scanner));
        spc.setReqdExctnDt(read(scanner));

        // UltmtDbtr
        spc.setUdName(read(scanner));
        spc.setUdStrtNm(read(scanner));
        spc.setUdBldgNb(read(scanner));
        spc.setUdPstCd(read(scanner));
        spc.setUdTwnNm(read(scanner));
        spc.setUdCtry(read(scanner));

        // RmtInf
        spc.setTp(read(scanner));
        spc.setRef(read(scanner));
        spc.setUstrd(read(scanner));

        // AltPmtInf
        spc.setAltPmts(readAltPmts(scanner));

        return spc;
    }

    private static List<String> readAltPmts(final Scanner scanner) {
        List<String> altPmts = null;
        String altPmt;
        for(int cnt = 0; (altPmt = read(scanner)) != null; ++cnt) {
            if(altPmts == null) {
                altPmts = new ArrayList<>();
            }
            // by now limit is 2 times AltPmt, we read a bit more and then validate
            if(cnt >= 10) {
                // but in order to be more robust in case a long input is provided, we give a hard limit of 10 for the addi
                break;
            }
            altPmts.add(altPmt);
        }
        return altPmts;
    }

    private static String read(final Scanner scanner) {
        if(scanner.hasNext()) {
            return emptyStringAsNull(scanner.next());
        } else {
            return null;
        }
    }

}
