package ch.codeblock.qrinvoice.model.builder;

import ch.codeblock.qrinvoice.model.Creditor;

public final class CreditorBuilder {
    private String name;
    private String streetName;
    private String houseNumber;
    private String postalCode;
    private String city;
    private String country;

    private CreditorBuilder() {
    }

    public static CreditorBuilder create() {
        return new CreditorBuilder();
    }

    public CreditorBuilder name(String name) {
        this.name = name;
        return this;
    }

    public CreditorBuilder streetName(String streetName) {
        this.streetName = streetName;
        return this;
    }

    public CreditorBuilder houseNumber(String houseNumber) {
        this.houseNumber = houseNumber;
        return this;
    }

    public CreditorBuilder postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    public CreditorBuilder city(String city) {
        this.city = city;
        return this;
    }

    public CreditorBuilder country(String country) {
        this.country = country;
        return this;
    }

    public Creditor build() {
        Creditor creditor = new Creditor();
        creditor.setName(name);
        creditor.setStreetName(streetName);
        creditor.setHouseNumber(houseNumber);
        creditor.setPostalCode(postalCode);
        creditor.setCity(city);
        creditor.setCountry(country);
        return creditor;
    }
}
