package ch.codeblock.qrinvoice.model.builder;

import ch.codeblock.qrinvoice.model.PaymentReference;
import ch.codeblock.qrinvoice.model.PaymentReference.ReferenceType;

import static ch.codeblock.qrinvoice.model.PaymentReference.ReferenceType.*;

public final class PaymentReferenceBuilder {
    private ReferenceType referenceType;
    private String reference;
    private String unstructuredMessage;

    private PaymentReferenceBuilder() {
    }

    public static PaymentReferenceBuilder create() {
        return new PaymentReferenceBuilder();
    }

    public PaymentReferenceBuilder referenceType(ReferenceType referenceType) {
        this.referenceType = referenceType;
        return this;
    }

    public PaymentReferenceBuilder reference(String reference) {
        this.reference = reference;
        return this;
    }

    public PaymentReferenceBuilder unstructuredMessage(String unstructuredMessage) {
        this.unstructuredMessage = unstructuredMessage;
        return this;
    }

    public PaymentReferenceBuilder qrReference(String reference) {
        return referenceType(QR_REFERENCE).reference(reference);
    }

    public PaymentReferenceBuilder creditorReference(String reference) {
        return referenceType(CREDITOR_REFERENCE).reference(reference);
    }

    public PaymentReferenceBuilder withoutReference(String reference) {
        return referenceType(WITHOUT_REFERENCE);
    }

    public PaymentReference build() {
        if(referenceType == null) {
            // referenceType is mandatory, but if no reference is provided, WITHOUT_REFERENCE makes total sense as a default
            referenceType = WITHOUT_REFERENCE;
        }
        PaymentReference paymentReference = new PaymentReference();
        paymentReference.setReferenceType(referenceType);
        paymentReference.setReference(reference);
        paymentReference.setUnstructuredMessage(unstructuredMessage);
        return paymentReference;
    }
}
