package ch.codeblock.qrinvoice.model.builder;

import ch.codeblock.qrinvoice.model.UltimateCreditor;

public final class UltimateCreditorBuilder {
    private String name;
    private String streetName;
    private String houseNumber;
    private String postalCode;
    private String city;
    private String country;

    private UltimateCreditorBuilder() {
    }

    public static UltimateCreditorBuilder create() {
        return new UltimateCreditorBuilder();
    }

    /**
     * @see UltimateCreditor#name
     */
    public UltimateCreditorBuilder name(String name) {
        this.name = name;
        return this;
    }

    public UltimateCreditorBuilder streetName(String streetName) {
        this.streetName = streetName;
        return this;
    }

    public UltimateCreditorBuilder houseNumber(String houseNumber) {
        this.houseNumber = houseNumber;
        return this;
    }

    public UltimateCreditorBuilder postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    public UltimateCreditorBuilder city(String city) {
        this.city = city;
        return this;
    }

    public UltimateCreditorBuilder country(String country) {
        this.country = country;
        return this;
    }

    public UltimateCreditor build() {
        UltimateCreditor ultimateCreditor = new UltimateCreditor();
        ultimateCreditor.setName(name);
        ultimateCreditor.setStreetName(streetName);
        ultimateCreditor.setHouseNumber(houseNumber);
        ultimateCreditor.setPostalCode(postalCode);
        ultimateCreditor.setCity(city);
        ultimateCreditor.setCountry(country);
        return ultimateCreditor;
    }
}
