package ch.codeblock.qrinvoice.model.util;

import ch.codeblock.qrinvoice.model.interfaces.Address;
import ch.codeblock.qrinvoice.util.StringUtils;

public class AddressUtils {

    public static boolean isEmpty(Address address) {
        return StringUtils.isEmpty(address.getName()) &&
                StringUtils.isEmpty(address.getStreetName()) &&
                StringUtils.isEmpty(address.getHouseNumber()) &&
                StringUtils.isEmpty(address.getPostalCode()) &&
                StringUtils.isEmpty(address.getCity()) &&
                StringUtils.isEmpty(address.getCountry());
    }

    public static String toAddress(final Address address) {
        if (address == null || address.isEmpty()) {
            return null;
        }
        return toAddress(
                address.getName(),
                address.getStreetName(),
                address.getHouseNumber(),
                address.getCountry(),
                address.getPostalCode(),
                address.getCity());
    }

    private static String toAddress(final String name, final String streetName, final String houseNumber, final String country, final String postalCode, final String city) {
        final boolean hasName = StringUtils.isNotEmpty(name);
        final boolean hasStreetName = StringUtils.isNotEmpty(streetName);
        final boolean hasHouseNumber = StringUtils.isNotEmpty(houseNumber);
        final boolean hasCountry = StringUtils.isNotEmpty(country);
        final boolean hasPostalCode = StringUtils.isNotEmpty(postalCode);
        final boolean hasCity = StringUtils.isNotEmpty(city);

        final boolean line1 = hasName;
        final boolean line2 = hasStreetName || hasHouseNumber;
        final boolean line3 = hasCountry || hasPostalCode || hasCity;
        
        final StringBuilder sb = new StringBuilder();
        if(line1) {
            sb.append(name);
        }
        
        if(line1 && (line2 || line3)) {
            sb.append("\n");
        }
        
        if (line2) {
            if (hasStreetName) {
                sb.append(streetName);
            }
            if (hasStreetName && hasHouseNumber) {
                sb.append(" ");
            }
            if (hasHouseNumber) {
                sb.append(houseNumber);
            }
        }
        
        if(line2 && line3) {
            sb.append("\n");
        }

        if(line3) {
            if(hasCountry) {
                sb.append(country);
            }
            if(hasCountry && hasPostalCode) {
                sb.append("-");
            }
            if(hasPostalCode) {
                sb.append(postalCode);
            }
            if(hasPostalCode && hasCity) {
                sb.append(" ");
            }
            if(hasCity) {
                sb.append(city);
            }
        }
        
        return sb.toString();
    }
}
