package ch.codeblock.qrinvoice.paymentpart;


import ch.codeblock.qrinvoice.NotYetImplementedException;
import ch.codeblock.qrinvoice.OutputFormat;
import ch.codeblock.qrinvoice.PageSize;
import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.mapper.ModelToSwissPaymentsCodeMapper;
import ch.codeblock.qrinvoice.qrcode.SwissQrCodeWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Iterator;
import java.util.Locale;
import java.util.ServiceLoader;

public class PaymentPartWriter {
    private final Logger logger = LoggerFactory.getLogger(PaymentPartWriter.class);

    public byte[] write(final PageSize pageSize, final OutputFormat outputFormat, final Locale locale, final QrInvoice qrInvoice) {

        final IPaymentPartWriter paymentPartWriter = selectPaymentPartWriter(pageSize, outputFormat, locale);
        final int pixels = paymentPartWriter.getQrCodeImageSize();

        final String swissPaymentsCode = new ModelToSwissPaymentsCodeMapper().map(qrInvoice).toSwissPaymentsCodeString();
        final byte[] qrCodeImage = new SwissQrCodeWriter().write(OutputFormat.PNG, swissPaymentsCode, pixels);

        return paymentPartWriter.write(qrInvoice, qrCodeImage);
    }

    private IPaymentPartWriter selectPaymentPartWriter(final PageSize pageSize, final OutputFormat outputFormat, final Locale locale) {
        switch (outputFormat) {
            case PDF:
                final ServiceLoader<IPaymentPartWriterFactory> partWriterFactories = ServiceLoader.load(IPaymentPartWriterFactory.class);
                final Iterator<IPaymentPartWriterFactory> iterator = partWriterFactories.iterator();
                final IPaymentPartWriterFactory selectedPaymentPartWriter = iterator.next();
                if (iterator.hasNext()) {
                    logger.warn("There is currently more than one implementation of IPaymentPartWriterFactory available at runtime. The following has been chosen to work with: {}", selectedPaymentPartWriter.getClass());
                }
                return selectedPaymentPartWriter.create(pageSize, locale);
            case PNG:
            default:
                throw new NotYetImplementedException("Output Format " + outputFormat + " has not yet been implemented");
        }
    }
}
