package ch.codeblock.qrinvoice.util;

import ch.codeblock.qrinvoice.NotYetImplementedException;

import java.math.BigDecimal;
import java.util.Objects;

public class NumberUtils {
    public static <T extends Number> T subtract(final T from, final T subtract) {
        if(Objects.isNull(from) || Objects.isNull(subtract)) {
            throw new IllegalArgumentException("only non-null values must be passed");
        }
        if(from instanceof Integer ) {
            return (T) Integer.valueOf(from.intValue() - subtract.intValue());
        } else if(from instanceof Float ) {
            return (T) Float.valueOf(from.floatValue() - subtract.floatValue());
        } else if (from instanceof Double) {
            return (T) Double.valueOf(from.doubleValue() - subtract.doubleValue());
        } else if(from instanceof Long ) {
            return (T) Long.valueOf(from.longValue() - subtract.longValue());
        }else if(from instanceof Short ) {
            return (T) Short.valueOf((short) (from.shortValue() - subtract.shortValue()));
        }else if(from instanceof BigDecimal) {
            return (T) ((BigDecimal) from).subtract((BigDecimal) subtract);
        } else {
            throw new NotYetImplementedException();
        }
    }
    public static <T extends Number> T add(final T a, final T b) {
        if(Objects.isNull(a) || Objects.isNull(b)) {
            throw new IllegalArgumentException("only non-null values must be passed");
        }
        if(a instanceof Integer ) {
            return (T) Integer.valueOf(a.intValue() + b.intValue());
        } else if(a instanceof Float ) {
            return (T) Float.valueOf(a.floatValue() + b.floatValue());
        } else if (a instanceof Double) {
            return (T) Double.valueOf(a.doubleValue() + b.doubleValue());
        } else if(a instanceof Long ) {
            return (T) Long.valueOf(a.longValue() + b.longValue());
        }else if(a instanceof Short ) {
            return (T) Short.valueOf((short) (a.shortValue() + b.shortValue()));
        }else if(a instanceof BigDecimal) {
            return (T) ((BigDecimal) a).add((BigDecimal) b);
        } else {
            throw new NotYetImplementedException();
        }
    }
}
