/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice;

import ch.codeblock.qrinvoice.OutputFormat;
import ch.codeblock.qrinvoice.PageSize;
import ch.codeblock.qrinvoice.QrInvoiceSpec;
import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.validation.ValidationException;
import ch.codeblock.qrinvoice.paymentpart.PaymentPartWriter;
import java.util.Locale;

public class QrInvoicePaymentPartCreator {
    private QrInvoice qrInvoice;
    private PageSize pageSize;
    private OutputFormat outputFormat;
    private Locale locale;

    private QrInvoicePaymentPartCreator() {
    }

    public static QrInvoicePaymentPartCreator create() {
        return new QrInvoicePaymentPartCreator();
    }

    public QrInvoicePaymentPartCreator qrInvoice(QrInvoice qrInvoice) {
        this.qrInvoice = qrInvoice;
        return this;
    }

    public QrInvoicePaymentPartCreator outputFormat(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    public QrInvoicePaymentPartCreator pageSize(PageSize pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public QrInvoicePaymentPartCreator locale(Locale locale) {
        if (!QrInvoiceSpec.SUPPORTED_LOCALES.contains(locale)) {
            throw new ValidationException("Unsupported locale '" + locale + "'");
        }
        this.locale = locale;
        return this;
    }

    public QrInvoicePaymentPartCreator inGerman() {
        this.locale(Locale.GERMAN);
        return this;
    }

    public QrInvoicePaymentPartCreator inFrench() {
        this.locale(Locale.FRENCH);
        return this;
    }

    public QrInvoicePaymentPartCreator inEnglish() {
        this.locale(Locale.ENGLISH);
        return this;
    }

    public QrInvoicePaymentPartCreator inItalian() {
        this.locale(Locale.ITALIAN);
        return this;
    }

    public byte[] createPaymentPart() {
        if (this.pageSize == null) {
            this.pageSize = PageSize.A4;
        }
        if (this.outputFormat == null) {
            this.outputFormat = OutputFormat.PDF;
        }
        if (this.locale == null) {
            this.locale = Locale.GERMAN;
        }
        return new PaymentPartWriter().write(this.pageSize, this.outputFormat, this.locale, this.qrInvoice);
    }
}

