/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice;

import ch.codeblock.qrinvoice.layout.Dimension;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Currency;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;

public class QrInvoiceSpec {
    public static final String ELEMENT_SEPARATOR = "\r\n";
    public static final Pattern ELEMENT_SEPARATOR_PATTERN = Pattern.compile("\\r\\n|\\n|\\r");
    public static final String QR_TYPE = "SPC";
    public static final String VERSION = "0100";
    public static final byte CODING_TPYE = 1;
    public static final Charset ENCODING = Charset.forName("ISO-8859-15");
    public static final char AMOUNT_DECIMAL_FORMAT_DECIMAL_SEPARATOR = '.';
    public static final char AMOUNT_DECIMAL_FORMAT_GROUPING_SEPARATOR = ' ';
    public static final String AMOUNT_DECIMAL_FORMAT_QRCODE = "#######.##";
    public static final String AMOUNT_DECIMAL_FORMAT_PRINT = "#,###,###.##";
    public static final BigDecimal AMOUNT_MIN = BigDecimal.ZERO;
    public static final BigDecimal AMOUNT_MAX = BigDecimal.valueOf(9.9999999999E8);
    public static final String DATE_FORMAT_PRINT = "dd.MM.yyyy";
    public static final Set<Locale> SUPPORTED_LOCALES = new HashSet<Locale>(Arrays.asList(Locale.GERMAN, Locale.FRENCH, Locale.ENGLISH, Locale.ITALIAN));
    public static final Currency CHF = Currency.getInstance("CHF");
    public static final Currency EUR = Currency.getInstance("EUR");
    public static final Set<Currency> SUPPORTED_CURRENCIES = new HashSet<Currency>(Arrays.asList(CHF, EUR));
    public static final String COUNTRY_CODE_SWITZERLAND = "CH";
    public static final String COUNTRY_CODE_LIECHTENSTEIN = "LI";
    public static final Set<String> SUPPORTED_IBAN_COUNTRIES = new HashSet<String>(Arrays.asList("CH", "LI"));
    public static final int MAX_ALT_PMT = 2;
    public static final Dimension<Integer> QR_CODE_SIZE = new Dimension<Integer>(46, 46);
    public static final Dimension<Integer> QR_CODE_LOGO_SIZE = new Dimension<Integer>(7, 7);
    public static final int QUIET_SPACE = 5;
    public static final float BOX_CORNER_LENGTH = 3.5f;
    public static final Dimension<Integer> DEBTOR_FIELD = new Dimension<Integer>(65, 25);
    public static final Dimension<Integer> AMOUNT_FIELD = new Dimension<Integer>(40, 15);
    public static final Dimension<Integer> AMOUNT_SECTION = new Dimension<Integer>(QR_CODE_SIZE.getWidth() + 5, AMOUNT_FIELD.getHeight() + 7);
}

