/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.layout;

import ch.codeblock.qrinvoice.layout.Dimension;
import ch.codeblock.qrinvoice.layout.Point;
import ch.codeblock.qrinvoice.util.NumberUtils;

public class Rect<T extends Number>
extends Dimension<T> {
    private final T llx;
    private final T lly;
    private final T urx;
    private final T ury;

    public Rect(T llx, T lly, T urx, T ury) {
        this(llx, lly, urx, ury, NumberUtils.subtract(urx, llx), NumberUtils.subtract(ury, lly));
    }

    public Rect(T llx, T lly, T urx, T ury, T width, T height) {
        super(width, height);
        this.llx = llx;
        this.lly = lly;
        this.urx = urx;
        this.ury = ury;
    }

    public T getLowerLeftX() {
        return this.llx;
    }

    public T getUpperRightX() {
        return this.urx;
    }

    public T getUpperRightY() {
        return this.ury;
    }

    public T getLowerLeftY() {
        return this.lly;
    }

    public Rect<T> move(Point<T> offset) {
        return this.move(offset.getX(), offset.getY());
    }

    public Rect<T> move(T offsetX, T offsetY) {
        return Rect.createUsingDimension(NumberUtils.add(this.llx, offsetX), NumberUtils.add(this.lly, offsetY), this.getWidth(), this.getHeight());
    }

    public static <T extends Number> Rect<T> create(T llx, T lly, T urx, T ury) {
        return new Rect<T>(llx, lly, urx, ury);
    }

    public static <T extends Number> Rect<T> createUsingDimension(T llx, T lly, Dimension<T> dimension) {
        return Rect.createUsingDimension(llx, lly, dimension.getWidth(), dimension.getHeight());
    }

    public static <T extends Number> Rect<T> createUsingDimension(T llx, T lly, T width, T height) {
        return new Rect<T>(llx, lly, NumberUtils.add(llx, width), NumberUtils.add(lly, height), width, height);
    }
}

