/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.model;

import ch.codeblock.qrinvoice.QrInvoiceSpec;
import ch.codeblock.qrinvoice.model.ParseException;
import ch.codeblock.qrinvoice.util.CollectionUtils;
import ch.codeblock.qrinvoice.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;

public final class SwissPaymentsCode {
    private String qrType;
    private String version;
    private String coding;
    private String iban;
    private String crName;
    private String crStrtNm;
    private String crBldgNb;
    private String crPstCd;
    private String crTwnNm;
    private String crCtry;
    private String ucrName;
    private String ucrStrtNm;
    private String ucrBldgNb;
    private String ucrPstCd;
    private String ucrTwnNm;
    private String ucrCtry;
    private String amt;
    private String ccy;
    private String reqdExctnDt;
    private String udName;
    private String udStrtNm;
    private String udBldgNb;
    private String udPstCd;
    private String udTwnNm;
    private String udCtry;
    private String tp;
    private String ref;
    private String ustrd;
    private List<String> altPmts;

    public String getQrType() {
        return this.qrType;
    }

    public void setQrType(String qrType) {
        this.qrType = qrType;
    }

    public String getCoding() {
        return this.coding;
    }

    public void setCoding(String coding) {
        this.coding = coding;
    }

    public String getIban() {
        return this.iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public String getCrName() {
        return this.crName;
    }

    public void setCrName(String crName) {
        this.crName = crName;
    }

    public String getCrStrtNm() {
        return this.crStrtNm;
    }

    public void setCrStrtNm(String crStrtNm) {
        this.crStrtNm = crStrtNm;
    }

    public String getCrBldgNb() {
        return this.crBldgNb;
    }

    public void setCrBldgNb(String crBldgNb) {
        this.crBldgNb = crBldgNb;
    }

    public String getCrPstCd() {
        return this.crPstCd;
    }

    public void setCrPstCd(String crPstCd) {
        this.crPstCd = crPstCd;
    }

    public String getCrTwnNm() {
        return this.crTwnNm;
    }

    public void setCrTwnNm(String crTwnNm) {
        this.crTwnNm = crTwnNm;
    }

    public String getCrCtry() {
        return this.crCtry;
    }

    public void setCrCtry(String crCtry) {
        this.crCtry = crCtry;
    }

    public String getUcrName() {
        return this.ucrName;
    }

    public void setUcrName(String ucrName) {
        this.ucrName = ucrName;
    }

    public String getUcrStrtNm() {
        return this.ucrStrtNm;
    }

    public void setUcrStrtNm(String ucrStrtNm) {
        this.ucrStrtNm = ucrStrtNm;
    }

    public String getUcrBldgNb() {
        return this.ucrBldgNb;
    }

    public void setUcrBldgNb(String ucrBldgNb) {
        this.ucrBldgNb = ucrBldgNb;
    }

    public String getUcrPstCd() {
        return this.ucrPstCd;
    }

    public void setUcrPstCd(String ucrPstCd) {
        this.ucrPstCd = ucrPstCd;
    }

    public String getUcrTwnNm() {
        return this.ucrTwnNm;
    }

    public void setUcrTwnNm(String ucrTwnNm) {
        this.ucrTwnNm = ucrTwnNm;
    }

    public String getUcrCtry() {
        return this.ucrCtry;
    }

    public void setUcrCtry(String ucrCtry) {
        this.ucrCtry = ucrCtry;
    }

    public String getAmt() {
        return this.amt;
    }

    public void setAmt(String amt) {
        this.amt = amt;
    }

    public String getCcy() {
        return this.ccy;
    }

    public void setCcy(String ccy) {
        this.ccy = ccy;
    }

    public String getReqdExctnDt() {
        return this.reqdExctnDt;
    }

    public void setReqdExctnDt(String reqdExctnDt) {
        this.reqdExctnDt = reqdExctnDt;
    }

    public String getUdName() {
        return this.udName;
    }

    public void setUdName(String udName) {
        this.udName = udName;
    }

    public String getUdStrtNm() {
        return this.udStrtNm;
    }

    public void setUdStrtNm(String udStrtNm) {
        this.udStrtNm = udStrtNm;
    }

    public String getUdBldgNb() {
        return this.udBldgNb;
    }

    public void setUdBldgNb(String udBldgNb) {
        this.udBldgNb = udBldgNb;
    }

    public String getUdPstCd() {
        return this.udPstCd;
    }

    public void setUdPstCd(String udPstCd) {
        this.udPstCd = udPstCd;
    }

    public String getUdTwnNm() {
        return this.udTwnNm;
    }

    public void setUdTwnNm(String udTwnNm) {
        this.udTwnNm = udTwnNm;
    }

    public String getUdCtry() {
        return this.udCtry;
    }

    public void setUdCtry(String udCtry) {
        this.udCtry = udCtry;
    }

    public String getTp() {
        return this.tp;
    }

    public void setTp(String tp) {
        this.tp = tp;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getUstrd() {
        return this.ustrd;
    }

    public void setUstrd(String ustrd) {
        this.ustrd = ustrd;
    }

    public List<String> getAltPmts() {
        return this.altPmts;
    }

    public void setAltPmts(List<String> altPmts) {
        this.altPmts = altPmts;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SwissPaymentsCode that = (SwissPaymentsCode)o;
        return Objects.equals(this.qrType, that.qrType) && Objects.equals(this.version, that.version) && Objects.equals(this.coding, that.coding) && Objects.equals(this.iban, that.iban) && Objects.equals(this.crName, that.crName) && Objects.equals(this.crStrtNm, that.crStrtNm) && Objects.equals(this.crBldgNb, that.crBldgNb) && Objects.equals(this.crPstCd, that.crPstCd) && Objects.equals(this.crTwnNm, that.crTwnNm) && Objects.equals(this.crCtry, that.crCtry) && Objects.equals(this.ucrName, that.ucrName) && Objects.equals(this.ucrStrtNm, that.ucrStrtNm) && Objects.equals(this.ucrBldgNb, that.ucrBldgNb) && Objects.equals(this.ucrPstCd, that.ucrPstCd) && Objects.equals(this.ucrTwnNm, that.ucrTwnNm) && Objects.equals(this.ucrCtry, that.ucrCtry) && Objects.equals(this.amt, that.amt) && Objects.equals(this.ccy, that.ccy) && Objects.equals(this.reqdExctnDt, that.reqdExctnDt) && Objects.equals(this.udName, that.udName) && Objects.equals(this.udStrtNm, that.udStrtNm) && Objects.equals(this.udBldgNb, that.udBldgNb) && Objects.equals(this.udPstCd, that.udPstCd) && Objects.equals(this.udTwnNm, that.udTwnNm) && Objects.equals(this.udCtry, that.udCtry) && Objects.equals(this.tp, that.tp) && Objects.equals(this.ref, that.ref) && Objects.equals(this.ustrd, that.ustrd) && Objects.equals(this.altPmts, that.altPmts);
    }

    public int hashCode() {
        return Objects.hash(this.qrType, this.version, this.coding, this.iban, this.crName, this.crStrtNm, this.crBldgNb, this.crPstCd, this.crTwnNm, this.crCtry, this.ucrName, this.ucrStrtNm, this.ucrBldgNb, this.ucrPstCd, this.ucrTwnNm, this.ucrCtry, this.amt, this.ccy, this.reqdExctnDt, this.udName, this.udStrtNm, this.udBldgNb, this.udPstCd, this.udTwnNm, this.udCtry, this.tp, this.ref, this.ustrd, this.altPmts);
    }

    public String toSwissPaymentsCodeString() {
        StringBuilder sb = new StringBuilder();
        this.appendField(sb, this.qrType);
        this.appendField(sb, this.version);
        this.appendField(sb, this.coding);
        this.appendField(sb, this.iban);
        this.appendField(sb, this.crName);
        this.appendField(sb, this.crStrtNm);
        this.appendField(sb, this.crBldgNb);
        this.appendField(sb, this.crPstCd);
        this.appendField(sb, this.crTwnNm);
        this.appendField(sb, this.crCtry);
        this.appendField(sb, this.ucrName);
        this.appendField(sb, this.ucrStrtNm);
        this.appendField(sb, this.ucrBldgNb);
        this.appendField(sb, this.ucrPstCd);
        this.appendField(sb, this.ucrTwnNm);
        this.appendField(sb, this.ucrCtry);
        this.appendField(sb, this.amt);
        this.appendField(sb, this.ccy);
        this.appendField(sb, this.reqdExctnDt);
        this.appendField(sb, this.udName);
        this.appendField(sb, this.udStrtNm);
        this.appendField(sb, this.udBldgNb);
        this.appendField(sb, this.udPstCd);
        this.appendField(sb, this.udTwnNm);
        this.appendField(sb, this.udCtry);
        this.appendField(sb, this.tp);
        this.appendField(sb, this.ref);
        this.appendField(sb, this.ustrd);
        if (CollectionUtils.isNotEmpty(this.altPmts)) {
            this.altPmts.forEach(altPmt -> this.appendField(sb, (String)altPmt));
        }
        return sb.toString();
    }

    private StringBuilder appendField(StringBuilder sb, String value) {
        if (value != null) {
            sb.append(value);
        }
        sb.append("\r\n");
        return sb;
    }

    public String toString() {
        return "SwissPaymentsCode{qrType='" + this.qrType + '\'' + ", version='" + this.version + '\'' + ", coding='" + this.coding + '\'' + ", iban='" + this.iban + '\'' + ", crName='" + this.crName + '\'' + ", crStrtNm='" + this.crStrtNm + '\'' + ", crBldgNb='" + this.crBldgNb + '\'' + ", crPstCd='" + this.crPstCd + '\'' + ", crTwnNm='" + this.crTwnNm + '\'' + ", crCtry='" + this.crCtry + '\'' + ", ucrName='" + this.ucrName + '\'' + ", ucrStrtNm='" + this.ucrStrtNm + '\'' + ", ucrBldgNb='" + this.ucrBldgNb + '\'' + ", ucrPstCd='" + this.ucrPstCd + '\'' + ", ucrTwnNm='" + this.ucrTwnNm + '\'' + ", ucrCtry='" + this.ucrCtry + '\'' + ", amt='" + this.amt + '\'' + ", ccy='" + this.ccy + '\'' + ", reqdExctnDt='" + this.reqdExctnDt + '\'' + ", udName='" + this.udName + '\'' + ", udStrtNm='" + this.udStrtNm + '\'' + ", udBldgNb='" + this.udBldgNb + '\'' + ", udPstCd='" + this.udPstCd + '\'' + ", udTwnNm='" + this.udTwnNm + '\'' + ", udCtry='" + this.udCtry + '\'' + ", tp='" + this.tp + '\'' + ", ref='" + this.ref + '\'' + ", ustrd='" + this.ustrd + '\'' + ", altPmts='" + this.altPmts + '\'' + '}';
    }

    public static SwissPaymentsCode parse(String swissPaymentsCode) {
        try {
            return SwissPaymentsCode.internalParse(swissPaymentsCode);
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (Exception e) {
            throw new ParseException("Unexpected exception occured during Swiss Payment Code Parsing", e);
        }
    }

    private static SwissPaymentsCode internalParse(String swissPaymentsCode) {
        if (swissPaymentsCode == null) {
            throw new ParseException("Encountered unexpected null instead of SwissPaymentsCode String");
        }
        Scanner scanner = new Scanner(swissPaymentsCode).useDelimiter(QrInvoiceSpec.ELEMENT_SEPARATOR_PATTERN);
        SwissPaymentsCode spc = new SwissPaymentsCode();
        spc.setQrType(SwissPaymentsCode.read(scanner));
        if (!"SPC".equals(spc.getQrType())) {
            throw new ParseException("QR-Type 'SPC' expected, but '" + spc.getQrType() + "' encountered");
        }
        spc.setVersion(SwissPaymentsCode.read(scanner));
        spc.setCoding(SwissPaymentsCode.read(scanner));
        spc.setIban(SwissPaymentsCode.read(scanner));
        spc.setCrName(SwissPaymentsCode.read(scanner));
        spc.setCrStrtNm(SwissPaymentsCode.read(scanner));
        spc.setCrBldgNb(SwissPaymentsCode.read(scanner));
        spc.setCrPstCd(SwissPaymentsCode.read(scanner));
        spc.setCrTwnNm(SwissPaymentsCode.read(scanner));
        spc.setCrCtry(SwissPaymentsCode.read(scanner));
        spc.setUcrName(SwissPaymentsCode.read(scanner));
        spc.setUcrStrtNm(SwissPaymentsCode.read(scanner));
        spc.setUcrBldgNb(SwissPaymentsCode.read(scanner));
        spc.setUcrPstCd(SwissPaymentsCode.read(scanner));
        spc.setUcrTwnNm(SwissPaymentsCode.read(scanner));
        spc.setUcrCtry(SwissPaymentsCode.read(scanner));
        spc.setAmt(SwissPaymentsCode.read(scanner));
        spc.setCcy(SwissPaymentsCode.read(scanner));
        spc.setReqdExctnDt(SwissPaymentsCode.read(scanner));
        spc.setUdName(SwissPaymentsCode.read(scanner));
        spc.setUdStrtNm(SwissPaymentsCode.read(scanner));
        spc.setUdBldgNb(SwissPaymentsCode.read(scanner));
        spc.setUdPstCd(SwissPaymentsCode.read(scanner));
        spc.setUdTwnNm(SwissPaymentsCode.read(scanner));
        spc.setUdCtry(SwissPaymentsCode.read(scanner));
        spc.setTp(SwissPaymentsCode.read(scanner));
        spc.setRef(SwissPaymentsCode.read(scanner));
        spc.setUstrd(SwissPaymentsCode.read(scanner));
        spc.setAltPmts(SwissPaymentsCode.readAltPmts(scanner));
        return spc;
    }

    private static List<String> readAltPmts(Scanner scanner) {
        String altPmt;
        ArrayList<String> altPmts = null;
        int cnt = 0;
        while ((altPmt = SwissPaymentsCode.read(scanner)) != null) {
            if (altPmts == null) {
                altPmts = new ArrayList<String>();
            }
            if (cnt >= 10) break;
            altPmts.add(altPmt);
            ++cnt;
        }
        return altPmts;
    }

    private static String read(Scanner scanner) {
        if (scanner.hasNext()) {
            return StringUtils.emptyStringAsNull(scanner.next());
        }
        return null;
    }
}

