/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.model.builder;

import ch.codeblock.qrinvoice.QrInvoiceSpec;
import ch.codeblock.qrinvoice.model.PaymentAmountInformation;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Currency;
import java.util.Date;

public final class PaymentAmountInformationBuilder {
    private BigDecimal amount;
    private Currency currency;
    private LocalDate date;

    private PaymentAmountInformationBuilder() {
    }

    public static PaymentAmountInformationBuilder create() {
        return new PaymentAmountInformationBuilder();
    }

    public PaymentAmountInformationBuilder amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    public PaymentAmountInformationBuilder amount(double amount) {
        return this.amount(BigDecimal.valueOf(amount));
    }

    public PaymentAmountInformationBuilder currency(Currency currency) {
        this.currency = currency;
        return this;
    }

    public PaymentAmountInformationBuilder date(LocalDate date) {
        this.date = date;
        return this;
    }

    public PaymentAmountInformationBuilder date(Date date) {
        LocalDate dateLocalDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return this.date(dateLocalDate);
    }

    public PaymentAmountInformationBuilder chf(BigDecimal amount) {
        return this.currency(QrInvoiceSpec.CHF).amount(amount);
    }

    public PaymentAmountInformationBuilder chf(double amount) {
        return this.currency(QrInvoiceSpec.CHF).amount(amount);
    }

    public PaymentAmountInformationBuilder eur(BigDecimal amount) {
        return this.currency(QrInvoiceSpec.EUR).amount(amount);
    }

    public PaymentAmountInformationBuilder eur(double amount) {
        return this.currency(QrInvoiceSpec.EUR).amount(amount);
    }

    public PaymentAmountInformationBuilder eur() {
        return this.currency(QrInvoiceSpec.EUR);
    }

    public PaymentAmountInformationBuilder chf() {
        return this.currency(QrInvoiceSpec.CHF);
    }

    public PaymentAmountInformation build() {
        PaymentAmountInformation paymentAmountInformation = new PaymentAmountInformation();
        paymentAmountInformation.setAmount(this.amount);
        paymentAmountInformation.setCurrency(this.currency);
        paymentAmountInformation.setDate(this.date);
        return paymentAmountInformation;
    }
}

