/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.model.builder;

import ch.codeblock.qrinvoice.model.AlternativeSchemes;
import ch.codeblock.qrinvoice.model.CreditorInformation;
import ch.codeblock.qrinvoice.model.Header;
import ch.codeblock.qrinvoice.model.PaymentAmountInformation;
import ch.codeblock.qrinvoice.model.PaymentReference;
import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.UltimateCreditor;
import ch.codeblock.qrinvoice.model.UltimateDebtor;
import ch.codeblock.qrinvoice.model.builder.AlternativeSchemesBuilder;
import ch.codeblock.qrinvoice.model.builder.CreditorBuilder;
import ch.codeblock.qrinvoice.model.builder.CreditorInformationBuilder;
import ch.codeblock.qrinvoice.model.builder.HeaderBuilder;
import ch.codeblock.qrinvoice.model.builder.PaymentAmountInformationBuilder;
import ch.codeblock.qrinvoice.model.builder.PaymentReferenceBuilder;
import ch.codeblock.qrinvoice.model.builder.UltimateCreditorBuilder;
import ch.codeblock.qrinvoice.model.builder.UltimateDebtorBuilder;
import ch.codeblock.qrinvoice.model.validation.QrInvoiceValidator;
import ch.codeblock.qrinvoice.util.CollectionUtils;
import java.util.List;
import java.util.function.Consumer;

public final class QrInvoiceBuilder {
    private CreditorInformationBuilder creditorInformationBuilder;
    private CreditorBuilder creditorBuilder;
    private UltimateCreditorBuilder ultimateCreditorBuilder;
    private UltimateDebtorBuilder ultimateDebtorBuilder;
    private PaymentAmountInformationBuilder paymentAmountInformationBuilder;
    private PaymentReferenceBuilder paymentReferenceBuilder;
    private AlternativeSchemesBuilder alternativeSchemesBuilder;
    private String iban;
    private List<String> alternativeSchemeParameters;

    private QrInvoiceBuilder() {
    }

    public static QrInvoiceBuilder create() {
        return new QrInvoiceBuilder();
    }

    private CreditorInformationBuilder creditorInformation() {
        if (this.creditorInformationBuilder == null) {
            this.creditorInformationBuilder = CreditorInformationBuilder.create();
        }
        return this.creditorInformationBuilder;
    }

    public CreditorBuilder creditor() {
        if (this.creditorBuilder == null) {
            this.creditorBuilder = CreditorBuilder.create();
        }
        return this.creditorBuilder;
    }

    public UltimateCreditorBuilder ultimateCreditor() {
        if (this.ultimateCreditorBuilder == null) {
            this.ultimateCreditorBuilder = UltimateCreditorBuilder.create();
        }
        return this.ultimateCreditorBuilder;
    }

    public UltimateDebtorBuilder ultimateDebtor() {
        if (this.ultimateDebtorBuilder == null) {
            this.ultimateDebtorBuilder = UltimateDebtorBuilder.create();
        }
        return this.ultimateDebtorBuilder;
    }

    public PaymentAmountInformationBuilder paymentAmountInformation() {
        if (this.paymentAmountInformationBuilder == null) {
            this.paymentAmountInformationBuilder = PaymentAmountInformationBuilder.create();
        }
        return this.paymentAmountInformationBuilder;
    }

    public PaymentReferenceBuilder paymentReference() {
        if (this.paymentReferenceBuilder == null) {
            this.paymentReferenceBuilder = PaymentReferenceBuilder.create();
        }
        return this.paymentReferenceBuilder;
    }

    private AlternativeSchemesBuilder alternativeSchemes() {
        if (this.alternativeSchemesBuilder == null) {
            this.alternativeSchemesBuilder = AlternativeSchemesBuilder.create();
        }
        return this.alternativeSchemesBuilder;
    }

    public QrInvoiceBuilder creditor(Consumer<CreditorBuilder> func) {
        func.accept(this.creditor());
        return this;
    }

    public QrInvoiceBuilder ultimateCreditor(Consumer<UltimateCreditorBuilder> func) {
        func.accept(this.ultimateCreditor());
        return this;
    }

    public QrInvoiceBuilder ultimateDebtor(Consumer<UltimateDebtorBuilder> func) {
        func.accept(this.ultimateDebtor());
        return this;
    }

    public QrInvoiceBuilder paymentAmountInformation(Consumer<PaymentAmountInformationBuilder> func) {
        func.accept(this.paymentAmountInformation());
        return this;
    }

    public QrInvoiceBuilder paymentReference(Consumer<PaymentReferenceBuilder> func) {
        func.accept(this.paymentReference());
        return this;
    }

    public QrInvoiceBuilder creditorIBAN(String iban) {
        this.iban = iban;
        return this;
    }

    public QrInvoiceBuilder alternativeSchemeParameters(List<String> alternativeSchemeParameters) {
        this.alternativeSchemeParameters = alternativeSchemeParameters;
        return this;
    }

    public QrInvoice build() {
        Header header = this.buildHeader();
        CreditorInformation creditorInformation = this.buildCreditorInformation();
        UltimateCreditor ultimateCreditor = this.buildUltimateCreditor();
        UltimateDebtor ultimateDebtor = this.buildUltimateDebtor();
        PaymentAmountInformation paymentAmountInformation = this.buildPaymentAmountInformation();
        PaymentReference paymentReference = this.buildPaymentReference();
        AlternativeSchemes alternativeSchemes = this.buildAlternativeSchemes();
        QrInvoice qrInvoice = new QrInvoice();
        qrInvoice.setHeader(header);
        qrInvoice.setCreditorInformation(creditorInformation);
        qrInvoice.setUltimateCreditor(ultimateCreditor);
        qrInvoice.setUltimateDebtor(ultimateDebtor);
        qrInvoice.setPaymentAmountInformation(paymentAmountInformation);
        qrInvoice.setPaymentReference(paymentReference);
        qrInvoice.setAlternativeSchemes(alternativeSchemes);
        QrInvoiceValidator qrInvoiceValidator = new QrInvoiceValidator();
        qrInvoiceValidator.validate(qrInvoice);
        return qrInvoice;
    }

    private Header buildHeader() {
        return HeaderBuilder.create().qrType("SPC").version(Short.parseShort("0100")).codingType((byte)1).build();
    }

    private CreditorInformation buildCreditorInformation() {
        return this.creditorInformation().creditor(this.creditor().build()).iban(this.iban).build();
    }

    private UltimateCreditor buildUltimateCreditor() {
        UltimateCreditor ultimateCreditor = this.ultimateCreditorBuilder != null ? this.ultimateCreditorBuilder.build() : null;
        return ultimateCreditor;
    }

    private UltimateDebtor buildUltimateDebtor() {
        UltimateDebtor ultimateDebtor = this.ultimateDebtorBuilder != null ? this.ultimateDebtorBuilder.build() : null;
        return ultimateDebtor;
    }

    private PaymentAmountInformation buildPaymentAmountInformation() {
        return this.paymentAmountInformation().build();
    }

    private PaymentReference buildPaymentReference() {
        return this.paymentReference().build();
    }

    private AlternativeSchemes buildAlternativeSchemes() {
        if (CollectionUtils.isNotEmpty(this.alternativeSchemeParameters)) {
            this.alternativeSchemes().alternativeSchemeParameters(this.alternativeSchemeParameters);
        }
        if (this.alternativeSchemesBuilder != null) {
            return this.alternativeSchemesBuilder.build();
        }
        return null;
    }
}

