/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.model.mapper;

import ch.codeblock.qrinvoice.MappingException;
import ch.codeblock.qrinvoice.model.AlternativeSchemes;
import ch.codeblock.qrinvoice.model.Creditor;
import ch.codeblock.qrinvoice.model.CreditorInformation;
import ch.codeblock.qrinvoice.model.Header;
import ch.codeblock.qrinvoice.model.PaymentAmountInformation;
import ch.codeblock.qrinvoice.model.PaymentReference;
import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.SwissPaymentsCode;
import ch.codeblock.qrinvoice.model.UltimateCreditor;
import ch.codeblock.qrinvoice.model.UltimateDebtor;
import ch.codeblock.qrinvoice.util.DecimalFormatFactory;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Currency;

public class ModelToSwissPaymentsCodeMapper {
    public SwissPaymentsCode map(QrInvoice qrInvoice) {
        SwissPaymentsCode spc = new SwissPaymentsCode();
        this.mapHeader(qrInvoice.getHeader(), spc);
        this.mapCreditorInformation(qrInvoice.getCreditorInformation(), spc);
        this.mapUltimateCreditor(qrInvoice.getUltimateCreditor(), spc);
        this.mapPaymentAmountInformation(qrInvoice.getPaymentAmountInformation(), spc);
        this.mapUltimateDebtor(qrInvoice.getUltimateDebtor(), spc);
        this.mapPaymentReference(qrInvoice.getPaymentReference(), spc);
        this.mapAlternativeSchemes(qrInvoice.getAlternativeSchemes(), spc);
        return spc;
    }

    private void mapPaymentReference(PaymentReference paymentReference, SwissPaymentsCode spc) {
        if (paymentReference == null) {
            throw new MappingException("PaymentReference must be given");
        }
        spc.setTp(paymentReference.getReferenceType().getReferenceTypeCode());
        spc.setRef(paymentReference.getReference());
        spc.setUstrd(paymentReference.getUnstructuredMessage());
    }

    private void mapPaymentAmountInformation(PaymentAmountInformation paymentAmountInformation, SwissPaymentsCode spc) {
        if (paymentAmountInformation == null) {
            throw new MappingException("PaymentAmountInformation must be given");
        }
        BigDecimal amount = paymentAmountInformation.getAmount();
        if (amount != null) {
            spc.setAmt(DecimalFormatFactory.createQrCodeAmountFormat().format(amount));
        } else {
            spc.setAmt(null);
        }
        Currency currency = paymentAmountInformation.getCurrency();
        if (currency != null) {
            spc.setCcy(currency.getCurrencyCode());
        } else {
            spc.setCcy(null);
        }
        LocalDate date = paymentAmountInformation.getDate();
        if (date != null) {
            spc.setReqdExctnDt(date.format(DateTimeFormatter.ISO_DATE));
        } else {
            spc.setReqdExctnDt(null);
        }
    }

    private void mapUltimateDebtor(UltimateDebtor ultimateDebtor, SwissPaymentsCode spc) {
        if (ultimateDebtor == null) {
            return;
        }
        spc.setUdName(ultimateDebtor.getName());
        spc.setUdStrtNm(ultimateDebtor.getStreetName());
        spc.setUdBldgNb(ultimateDebtor.getHouseNumber());
        spc.setUdPstCd(ultimateDebtor.getPostalCode());
        spc.setUdTwnNm(ultimateDebtor.getCity());
        spc.setUdCtry(ultimateDebtor.getCountry());
    }

    private void mapHeader(Header header, SwissPaymentsCode spc) {
        if (header == null) {
            throw new MappingException("Header must be given");
        }
        spc.setQrType(header.getQrType());
        spc.setVersion(String.format("%04d", header.getVersion()));
        spc.setCoding(Byte.toString(header.getCodingType()));
    }

    private void mapCreditorInformation(CreditorInformation creditorInformation, SwissPaymentsCode spc) {
        if (creditorInformation == null) {
            throw new MappingException("CreditorInformation must be given");
        }
        spc.setIban(creditorInformation.getIban());
        this.mapCreditor(creditorInformation.getCreditor(), spc);
    }

    private void mapCreditor(Creditor creditor, SwissPaymentsCode spc) {
        if (creditor == null) {
            throw new MappingException("Creditor must be given");
        }
        spc.setCrName(creditor.getName());
        spc.setCrStrtNm(creditor.getStreetName());
        spc.setCrBldgNb(creditor.getHouseNumber());
        spc.setCrPstCd(creditor.getPostalCode());
        spc.setCrTwnNm(creditor.getCity());
        spc.setCrCtry(creditor.getCountry());
    }

    private void mapUltimateCreditor(UltimateCreditor ultimateCreditor, SwissPaymentsCode spc) {
        if (ultimateCreditor == null) {
            return;
        }
        spc.setUcrName(ultimateCreditor.getName());
        spc.setUcrStrtNm(ultimateCreditor.getStreetName());
        spc.setUcrBldgNb(ultimateCreditor.getHouseNumber());
        spc.setUcrPstCd(ultimateCreditor.getPostalCode());
        spc.setUcrTwnNm(ultimateCreditor.getCity());
        spc.setUcrCtry(ultimateCreditor.getCountry());
    }

    private void mapAlternativeSchemes(AlternativeSchemes alternativeSchemes, SwissPaymentsCode spc) {
        if (alternativeSchemes == null) {
            return;
        }
        spc.setAltPmts(alternativeSchemes.getAlternativeSchemeParameters());
    }
}

