/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.model.validation;

import ch.codeblock.qrinvoice.NotYetImplementedException;
import ch.codeblock.qrinvoice.QrInvoiceSpec;
import ch.codeblock.qrinvoice.model.AlternativeSchemes;
import ch.codeblock.qrinvoice.model.CreditorInformation;
import ch.codeblock.qrinvoice.model.Header;
import ch.codeblock.qrinvoice.model.PaymentAmountInformation;
import ch.codeblock.qrinvoice.model.PaymentReference;
import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.UltimateCreditor;
import ch.codeblock.qrinvoice.model.UltimateDebtor;
import ch.codeblock.qrinvoice.model.validation.AddressValidator;
import ch.codeblock.qrinvoice.model.validation.ValidationErrors;
import ch.codeblock.qrinvoice.model.validation.ValidationUtils;
import ch.codeblock.qrinvoice.util.CollectionUtils;
import ch.codeblock.qrinvoice.util.CreditorReferenceUtils;
import ch.codeblock.qrinvoice.util.IbanUtils;
import ch.codeblock.qrinvoice.util.QRReferenceUtils;
import java.math.BigDecimal;
import java.util.Currency;
import java.util.List;

public class QrInvoiceValidator {
    private final AddressValidator addressValidator = new AddressValidator();

    public ValidationErrors validate(QrInvoice qrInvoice) {
        ValidationErrors errors = new ValidationErrors();
        this.validate(qrInvoice.getHeader(), errors);
        this.validate(qrInvoice.getCreditorInformation(), errors);
        this.validate(qrInvoice.getUltimateCreditor(), errors);
        this.validate(qrInvoice.getUltimateDebtor(), errors);
        this.validate(qrInvoice.getPaymentAmountInformation(), errors);
        this.validate(qrInvoice.getPaymentReference(), errors);
        this.validate(qrInvoice.getAlternativeSchemes(), errors);
        this.validateCrossDependentElements(qrInvoice, errors);
        return errors;
    }

    private void validate(Header header, ValidationErrors errors) {
        byte codingType = header.getCodingType();
        ValidationUtils.validateTrue(codingType, codingType == 1, value -> errors.addError("header", "codingType", codingType, "validation.error.codingType"));
        short version = header.getVersion();
        ValidationUtils.validateTrue(version, version == Short.parseShort("0100"), value -> errors.addError("header", "version", version, "validation.error.version"));
        String qrType = header.getQrType();
        ValidationUtils.validateTrue(qrType, "SPC".equals(qrType), value -> errors.addError("header", "qrType", qrType, "validation.error.qrType"));
    }

    private void validate(CreditorInformation creditorInformation, ValidationErrors errors) {
        this.addressValidator.validate(creditorInformation.getCreditor(), errors);
        String iban = creditorInformation.getIban();
        ValidationUtils.validateTrue(iban, IbanUtils.isValidIBAN(iban, true), value -> errors.addError("creditorInformation", "iban", value, "validation.error.iban"));
    }

    private void validate(UltimateCreditor ultimateCreditor, ValidationErrors errors) {
        this.addressValidator.validate(ultimateCreditor, errors);
    }

    private void validate(UltimateDebtor ultimateDebtor, ValidationErrors errors) {
        this.addressValidator.validate(ultimateDebtor, errors);
    }

    private void validate(PaymentAmountInformation paymentAmountInformation, ValidationErrors errors) {
        BigDecimal amount = paymentAmountInformation.getAmount();
        ValidationUtils.validateRange(amount, QrInvoiceSpec.AMOUNT_MIN, QrInvoiceSpec.AMOUNT_MAX, value -> errors.addError("paymentAmountInformation", "amount", amount, "validation.error.amount"));
        Currency currency = paymentAmountInformation.getCurrency();
        ValidationUtils.validateTrue(currency, QrInvoiceSpec.SUPPORTED_CURRENCIES.contains(currency), value -> errors.addError("paymentAmountInformation", "currency", value, "validation.error.currency"));
    }

    private void validate(PaymentReference paymentReference, ValidationErrors errors) {
        PaymentReference.ReferenceType referenceType;
        ValidationUtils.validateTrue(referenceType, (referenceType = paymentReference.getReferenceType()) != null, value -> errors.addError("paymentReference", "referenceType", value, "validation.error.referenceType"));
        String reference = paymentReference.getReference();
        ValidationUtils.validateCharacters(reference, value -> errors.addError("paymentReference", "reference", value, "validation.error.invalidCharacters"));
        if (referenceType != null) {
            switch (referenceType) {
                case QR_REFERENCE: {
                    ValidationUtils.validateTrue(reference, QRReferenceUtils.isValid(reference), value -> errors.addError("paymentReference", "reference", value, "validation.error.reference", "validation.error.reference.QRR"));
                    break;
                }
                case CREDITOR_REFERENCE: {
                    ValidationUtils.validateTrue(reference, CreditorReferenceUtils.isValid(reference), value -> errors.addError("paymentReference", "reference", value, "validation.error.reference", "validation.error.reference.SCOR"));
                    break;
                }
                case WITHOUT_REFERENCE: {
                    ValidationUtils.validateEmpty(reference, value -> errors.addError("paymentReference", "reference", value, "validation.error.reference", "validation.error.reference.NON"));
                    break;
                }
                default: {
                    throw new NotYetImplementedException("ReferenceType '" + reference + "' is not yet implemented");
                }
            }
        }
        String unstructuredMessage = paymentReference.getUnstructuredMessage();
        ValidationUtils.validateOptionalLength(unstructuredMessage, 0, 140, value -> errors.addError("paymentReference", "unstructuredMessage", value, "validation.error.paymentReference.unstructuredMessage"));
        ValidationUtils.validateCharacters(unstructuredMessage, value -> errors.addError("paymentReference", "unstructuredMessage", value, "validation.error.invalidCharacters"));
    }

    private void validate(AlternativeSchemes alternativeSchemes, ValidationErrors errors) {
        if (alternativeSchemes != null) {
            List<String> alternativeSchemeParameters = alternativeSchemes.getAlternativeSchemeParameters();
            int size = CollectionUtils.size(alternativeSchemeParameters);
            if (size > 2) {
                errors.addError("alternativeSchemes", "alternativeSchemeParameters", size, "validation.error.alternativeSchemes.alternativeSchemeParameters.size");
            }
            if (size > 0) {
                for (String param : alternativeSchemeParameters) {
                    ValidationUtils.validateOptionalLength(param, 0, 100, value -> errors.addError("alternativeSchemes", "alternativeSchemeParameters", value, "validation.error.alternativeSchemes.alternativeSchemeParameter.length"));
                    ValidationUtils.validateCharacters(param, value -> errors.addError("alternativeSchemes", "alternativeSchemeParameters", value, "validation.error.invalidCharacters"));
                }
            }
        }
    }

    private void validateCrossDependentElements(QrInvoice qrInvoice, ValidationErrors errors) {
        String iban = qrInvoice.getCreditorInformation().getIban();
        if (IbanUtils.isQrIBAN(iban)) {
            PaymentReference.ReferenceType referenceType = qrInvoice.getPaymentReference().getReferenceType();
            if (referenceType != null) {
                switch (referenceType) {
                    case QR_REFERENCE: 
                    case CREDITOR_REFERENCE: {
                        return;
                    }
                }
            }
            errors.addError("paymentReference", "referenceType", referenceType, "validation.error.referenceType.qrIban");
        }
    }
}

