/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.model.validation;

import ch.codeblock.qrinvoice.util.EncodingUtils;
import ch.codeblock.qrinvoice.util.StringUtils;
import java.math.BigDecimal;
import java.util.function.Consumer;

public class ValidationUtils {
    public static void validateLength(CharSequence str, int min, int max, Consumer<CharSequence> validationErrorCallback) {
        ValidationUtils.validateLength(str, min, max, false, validationErrorCallback);
    }

    public static void validateOptionalLength(CharSequence str, int min, int max, Consumer<CharSequence> validationErrorCallback) {
        ValidationUtils.validateLength(str, min, max, true, validationErrorCallback);
    }

    private static void validateLength(CharSequence str, int min, int max, boolean optional, Consumer<CharSequence> validationErrorCallback) {
        if (!ValidationUtils.validateLength(str, min, max, optional)) {
            validationErrorCallback.accept(str);
        }
    }

    public static boolean validateLength(CharSequence str, int min, int max, boolean optional) {
        if (str == null || str.length() == 0 && min > 0) {
            return optional;
        }
        int length = str.length();
        return min <= length && length <= max;
    }

    public static void validateEmpty(String value, Consumer<String> validationErrorCallback) {
        if (StringUtils.isNotEmpty(value)) {
            validationErrorCallback.accept(value);
        }
    }

    public static void validateCharacters(String value, Consumer<CharSequence> validationErrorCallback) {
        if (StringUtils.isNotEmpty(value) && !EncodingUtils.isValidEncoding(value)) {
            validationErrorCallback.accept(value);
        }
    }

    public static void validateRange(BigDecimal number, BigDecimal min, BigDecimal max, Consumer<BigDecimal> validationErrorCallback) {
        ValidationUtils.validateRange(number, min, max, false, validationErrorCallback);
    }

    public static void validateOptionalRange(BigDecimal number, BigDecimal min, BigDecimal max, Consumer<BigDecimal> validationErrorCallback) {
        ValidationUtils.validateRange(number, min, max, true, validationErrorCallback);
    }

    private static void validateRange(BigDecimal number, BigDecimal min, BigDecimal max, boolean optional, Consumer<BigDecimal> validationErrorCallback) {
        if (!ValidationUtils.validateRange(number, min, max, optional)) {
            validationErrorCallback.accept(number);
        }
    }

    public static boolean validateRange(BigDecimal number, BigDecimal min, BigDecimal max, boolean optional) {
        if (number == null) {
            return optional;
        }
        boolean greaterOrEqualThanMin = number.compareTo(min) >= 0;
        boolean lessOrEqualThanMax = number.compareTo(max) <= 0;
        return greaterOrEqualThanMin && lessOrEqualThanMax;
    }

    public static <T> void validateTrue(T value, boolean valid, Consumer<T> validationErrorCallback) {
        if (!valid) {
            validationErrorCallback.accept(value);
        }
    }
}

