/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.qrcode;

import ch.codeblock.qrinvoice.BaseException;
import ch.codeblock.qrinvoice.NotYetImplementedException;
import ch.codeblock.qrinvoice.OutputFormat;
import ch.codeblock.qrinvoice.QrInvoiceSpec;
import ch.codeblock.qrinvoice.TechnicalException;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwissQrCodeWriter {
    private final Logger logger = LoggerFactory.getLogger(SwissQrCodeWriter.class);

    public byte[] write(OutputFormat outputFormat, String qrCodeString, int desiredQrCodeSize) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.renderSwissQrCode(outputFormat, qrCodeString, desiredQrCodeSize, baos);
            return baos.toByteArray();
        }
        catch (BaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TechnicalException("Unexpected exception encountered during SwissQrCode creation", e);
        }
    }

    private void renderSwissQrCode(OutputFormat outputFormat, String qrCodeString, int desiredQrCodeSize, OutputStream outputStream) throws WriterException, IOException {
        switch (outputFormat) {
            case PNG: {
                BufferedImage qrCodeImage = this.renderSwissQrCodeAsRasterizedGraphic(qrCodeString, desiredQrCodeSize);
                ImageIO.write((RenderedImage)qrCodeImage, outputFormat.name(), outputStream);
                break;
            }
            default: {
                throw new NotYetImplementedException("Output Format " + (Object)((Object)outputFormat) + " has not yet been implemented");
            }
        }
    }

    private BufferedImage renderSwissQrCodeAsRasterizedGraphic(String qrCodeString, int desiredQrCodeSize) throws WriterException, IOException {
        BufferedImage qrImage = this.renderQrCode(qrCodeString, desiredQrCodeSize);
        return this.overlayWithQrCodeLogo(qrImage);
    }

    private BufferedImage renderQrCode(String qrCodeString, int desiredQrCodeSize) throws WriterException {
        HashMap<EncodeHintType, Object> hintMap = new HashMap<EncodeHintType, Object>();
        hintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
        hintMap.put(EncodeHintType.MARGIN, 0);
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        int minimalQrCodeSize = this.getMinimalQrCodeSize(qrCodeString, hintMap);
        int optimalQrCodeRenderSize = this.getOptimalQrCodeRenderSize(desiredQrCodeSize, minimalQrCodeSize);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("desiredQrCodeSize: {}", (Object)desiredQrCodeSize);
            this.logger.trace("minimalQrCodeSize: {}", (Object)minimalQrCodeSize);
            this.logger.trace("optimalQrCodeRenderSize: {}", (Object)optimalQrCodeRenderSize);
        }
        BitMatrix bitMatrix = qrCodeWriter.encode(qrCodeString, BarcodeFormat.QR_CODE, optimalQrCodeRenderSize, optimalQrCodeRenderSize, hintMap);
        MatrixToImageConfig config = new MatrixToImageConfig(-16777216, -1);
        BufferedImage qrImage = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix, (MatrixToImageConfig)config);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("widht: {}", (Object)qrImage.getWidth());
            this.logger.trace("height: {}", (Object)qrImage.getHeight());
            this.logger.trace("qrImageWidth: {}", (Object)qrImage.getWidth());
            this.logger.trace("qrImageHeight: {}", (Object)qrImage.getHeight());
        }
        return qrImage;
    }

    private BufferedImage overlayWithQrCodeLogo(BufferedImage qrImage) throws IOException {
        int qrCodeWidth = qrImage.getWidth();
        int qrCodeHeight = qrImage.getHeight();
        BufferedImage combined = new BufferedImage(qrCodeWidth, qrCodeHeight, 2);
        Graphics2D g = (Graphics2D)combined.getGraphics();
        g.drawImage((Image)qrImage, 0, 0, null);
        g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        int qrLogoWidth = Math.floorDiv(qrCodeWidth * QrInvoiceSpec.QR_CODE_LOGO_SIZE.getWidth(), (int)QrInvoiceSpec.QR_CODE_SIZE.getWidth());
        int qrLogoHeight = Math.floorDiv(qrCodeHeight * QrInvoiceSpec.QR_CODE_LOGO_SIZE.getHeight(), (int)QrInvoiceSpec.QR_CODE_SIZE.getHeight());
        Image logoImage = ImageIO.read(this.getClass().getResourceAsStream("/ch/codeblock/qrinvoice/standards/kreuz.png")).getScaledInstance(qrLogoWidth, qrLogoHeight, -1);
        int deltaWidth = qrCodeWidth - qrLogoWidth;
        int deltaHeight = qrCodeHeight - qrLogoHeight;
        int qrLogoPositionX = Math.round(deltaWidth / 2);
        int qrLogoPositionY = Math.round(deltaHeight / 2);
        g.drawImage(logoImage, qrLogoPositionX, qrLogoPositionY, null);
        return combined;
    }

    private int getOptimalQrCodeRenderSize(int desiredQrCodeSize, int minimalQrCodeSize) {
        if (minimalQrCodeSize >= desiredQrCodeSize) {
            return minimalQrCodeSize;
        }
        return minimalQrCodeSize * Math.floorDiv(desiredQrCodeSize, minimalQrCodeSize);
    }

    private int getMinimalQrCodeSize(String qrCodeString, Map<EncodeHintType, ?> hintMap) throws WriterException {
        QRCode qrCode = Encoder.encode((String)qrCodeString, (ErrorCorrectionLevel)ErrorCorrectionLevel.M, hintMap);
        return qrCode.getMatrix().getWidth();
    }
}

