package ch.codeblock.qrinvoice;

import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.mapper.ModelToSwissPaymentsCodeMapper;
import ch.codeblock.qrinvoice.qrcode.SwissQrCodeWriter;

public class QrInvoiceCodeCreator {
    private QrInvoice qrInvoice;
    private int desiredQrCodeSize = -1;
    private OutputFormat outputFormat;

    private QrInvoiceCodeCreator(){
        
    }
    
    public static QrInvoiceCodeCreator create() {
        return new QrInvoiceCodeCreator();
    }
    
    public String createSwissPaymentsCode() {
        return new ModelToSwissPaymentsCodeMapper().map(qrInvoice).toSwissPaymentsCodeString();    
    }

    public QrInvoiceCodeCreator qrInvoice(final QrInvoice qrInvoice) {
        this.qrInvoice = qrInvoice;
        return this;
    }

    public QrInvoiceCodeCreator outputFormat(final OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    /***
     * 
     * @param desiredQrCodeSize in pixels
     * @return
     */
    public QrInvoiceCodeCreator desiredQrCodeSize(final int desiredQrCodeSize) {
        this.desiredQrCodeSize = desiredQrCodeSize;
        return this;
    }

    public byte[] createQrCode() {
        // apply defaults, if not explicitely set
        if(outputFormat == null) {
            outputFormat = OutputFormat.PNG;
        }
        return new SwissQrCodeWriter().write(outputFormat, createSwissPaymentsCode(), desiredQrCodeSize);
    }

}
