package ch.codeblock.qrinvoice.layout;

public class Dimension<T extends Number> {
    private final T width;
    private final T height;

    public Dimension(final T width, final T height) {
        this.width = width;
        this.height = height;
    }

    public T getWidth() {
        return width;
    }

    public T getHeight() {
        return height;
    }


    public Rect<T> toRectangle(final T x, final T y) {
        return Rect.createUsingDimension(x, y, this);
    }
}
