package ch.codeblock.qrinvoice.model;

import java.util.Objects;

/**
 * <p>Swiss QR Invoice root element</p>
 * <p>Data Structure Element</p>
 * <pre>
 *     QRCH
 * </pre>
 */
public class QrInvoice {
    private Header header;
    private CreditorInformation creditorInformation;
    private UltimateCreditor ultimateCreditor;
    private PaymentAmountInformation paymentAmountInformation;
    private UltimateDebtor ultimateDebtor;
    private PaymentReference paymentReference;
    private AlternativeSchemes alternativeSchemes;

    public Header getHeader() {
        return header;
    }

    public void setHeader(final Header header) {
        this.header = header;
    }

    public CreditorInformation getCreditorInformation() {
        return creditorInformation;
    }

    public void setCreditorInformation(final CreditorInformation creditorInformation) {
        this.creditorInformation = creditorInformation;
    }

    public UltimateCreditor getUltimateCreditor() {
        return ultimateCreditor;
    }

    public void setUltimateCreditor(final UltimateCreditor ultimateCreditor) {
        this.ultimateCreditor = ultimateCreditor;
    }

    public PaymentAmountInformation getPaymentAmountInformation() {
        return paymentAmountInformation;
    }

    public void setPaymentAmountInformation(final PaymentAmountInformation paymentAmountInformation) {
        this.paymentAmountInformation = paymentAmountInformation;
    }

    public UltimateDebtor getUltimateDebtor() {
        return ultimateDebtor;
    }

    public void setUltimateDebtor(final UltimateDebtor ultimateDebtor) {
        this.ultimateDebtor = ultimateDebtor;
    }

    public PaymentReference getPaymentReference() {
        return paymentReference;
    }

    public void setPaymentReference(final PaymentReference paymentReference) {
        this.paymentReference = paymentReference;
    }

    public AlternativeSchemes getAlternativeSchemes() {
        return alternativeSchemes;
    }

    public void setAlternativeSchemes(final AlternativeSchemes alternativeSchemes) {
        this.alternativeSchemes = alternativeSchemes;
    }

    @Override
    public String toString() {
        return "QrInvoice{" +
                "header=" + header +
                ", creditorInformation=" + creditorInformation +
                ", ultimateCreditor=" + ultimateCreditor +
                ", paymentAmountInformation=" + paymentAmountInformation +
                ", ultimateDebtor=" + ultimateDebtor +
                ", paymentReference=" + paymentReference +
                ", alternativeSchemes=" + alternativeSchemes +
                '}';
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final QrInvoice qrInvoice = (QrInvoice) o;
        return Objects.equals(header, qrInvoice.header) &&
                Objects.equals(creditorInformation, qrInvoice.creditorInformation) &&
                Objects.equals(ultimateCreditor, qrInvoice.ultimateCreditor) &&
                Objects.equals(paymentAmountInformation, qrInvoice.paymentAmountInformation) &&
                Objects.equals(ultimateDebtor, qrInvoice.ultimateDebtor) &&
                Objects.equals(paymentReference, qrInvoice.paymentReference) &&
                Objects.equals(alternativeSchemes, qrInvoice.alternativeSchemes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(header, creditorInformation, ultimateCreditor, paymentAmountInformation, ultimateDebtor, paymentReference, alternativeSchemes);
    }
}
