package ch.codeblock.qrinvoice.model.builder;

import ch.codeblock.qrinvoice.model.Header;

public final class HeaderBuilder {
    private String qrType;
    private short version;
    private byte codingType;

    private HeaderBuilder() {
    }

    public static HeaderBuilder create() {
        return new HeaderBuilder();
    }

    public HeaderBuilder qrType(String qrType) {
        this.qrType = qrType;
        return this;
    }

    public HeaderBuilder version(short version) {
        this.version = version;
        return this;
    }

    public HeaderBuilder codingType(byte codingType) {
        this.codingType = codingType;
        return this;
    }

    public Header build() {
        Header header = new Header();
        header.setQrType(qrType);
        header.setVersion(version);
        header.setCodingType(codingType);
        return header;
    }
}
