package ch.codeblock.qrinvoice.model.validation;

import ch.codeblock.qrinvoice.BaseException;

public class ValidationException extends BaseException {
    private final ValidationResult validationResult;

    public ValidationException() {
        validationResult = null;
    }

    public ValidationException(final String message) {
        super(message);
        validationResult = null;
    }

    public ValidationException(final String message, final Throwable cause) {
        super(message, cause);
        validationResult = null;
    }

    public ValidationException(final Throwable cause) {
        super(cause);
        validationResult = null;
    }

    public ValidationException(final String message, final Throwable cause, final boolean enableSuppression, final boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        validationResult = null;
    }

    public ValidationException(final ValidationResult validationResult) {
        super(validationResult.getValidationErrorSummary());
        this.validationResult = validationResult;
    }

    public ValidationResult getValidationResult() {
        return validationResult;
    }
}
