package ch.codeblock.qrinvoice.paymentpart;

import ch.codeblock.qrinvoice.QrInvoiceSpec;
import ch.codeblock.qrinvoice.layout.Dimension;
import ch.codeblock.qrinvoice.layout.Rect;

import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.ResourceBundle;

import static ch.codeblock.qrinvoice.layout.DimensionUnitUtils.millimetersToPoints;

public abstract class AbstractItextPaymentPartWriter implements IPaymentPartWriter{
    protected static final String CHARSET = QrInvoiceSpec.ENCODING.name();
    protected static final int TITLE_FONT_SIZE = 11; // TODO as per spec
    protected static final int HEADING_FONT_SIZE = 7;
    protected static final int VALUE_FONT_SIZE = 9;

    protected static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern(QrInvoiceSpec.DATE_FORMAT_PRINT);

    protected static final Rect<Float> A6_LANDSCAPE = Rect.create(0f,0f,420f,297f);

    protected static final float QUIET_SPACE_PTS = millimetersToPoints(QrInvoiceSpec.QUIET_SPACE);
    protected static final float BOX_CORNER_LENGTH = millimetersToPoints(QrInvoiceSpec.BOX_CORNER_LENGTH);
    protected static final Dimension<Float> AMOUNT_FIELD = mmToPoints(QrInvoiceSpec.AMOUNT_FIELD);
    protected static final Dimension<Float> AMOUNT_SECTION = mmToPoints(QrInvoiceSpec.AMOUNT_SECTION);
    protected static final Dimension<Float> DEBTOR_FIELD = mmToPoints(QrInvoiceSpec.DEBTOR_FIELD);

    protected static Dimension<Float> mmToPoints(final Dimension<Integer> mmDimension) {
        return new Dimension<>(millimetersToPoints(mmDimension.getWidth()), millimetersToPoints(mmDimension.getHeight()));
    }

    protected static final Rect<Float> QR_CODE_RECTANGLE;

    static {
        final float x = QUIET_SPACE_PTS;
        final float y = QUIET_SPACE_PTS * 2 + AMOUNT_SECTION.getHeight();
        QR_CODE_RECTANGLE = Rect.createUsingDimension(x, y, mmToPoints(QrInvoiceSpec.QR_CODE_SIZE));
    }

    protected static final Rect<Float> INFORMATION_SECTION_RECT;

    static {
        final float x = (QUIET_SPACE_PTS + QR_CODE_RECTANGLE.getWidth() /* QR CODE Right X */) + QUIET_SPACE_PTS * 3;
        final float y = QUIET_SPACE_PTS;
        final float height = getPaymentPartHeight() - millimetersToPoints(20);
        final float width = millimetersToPoints(50);
        INFORMATION_SECTION_RECT = Rect.createUsingDimension(x, y, width, height);
    }

    protected static float getPaymentPartWidth() {
        return A6_LANDSCAPE.getWidth();
    }

    protected static float getPaymentPartHeight() {
        return A6_LANDSCAPE.getHeight();
    }


    private ResourceBundle labels;
    public AbstractItextPaymentPartWriter(final Locale locale) {
        labels = ResourceBundle.getBundle("qrinvoice", locale);
    }

    @Override
    public int getQrCodeImageSize() {
        final int dpi = 300;
        final float mm = QrInvoiceSpec.QR_CODE_SIZE.getWidth();
        final float mmPerInch = 25.4f; // 1 inch = 2.54 cm => 25.4mm
        return Math.round(dpi * mm / mmPerInch); // pixels
    }

    protected String getLabel(final String key) {
        return labels.getString(key);
    }

}
