package ch.codeblock.qrinvoice.util;

import ch.codeblock.qrinvoice.TechnicalException;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import static ch.codeblock.qrinvoice.QrInvoiceSpec.COUNTRY_CODE_SWITZERLAND;

/**
 * ISO 3166-1 Country Util
 */
public final class CountryUtils {
    private CountryUtils(){}
    
    private static final Properties COUNTRIES = new Properties();
    static {
        try(final InputStream is = CountryUtils.class.getResourceAsStream("/ch/codeblock/qrinvoice/standards/iso3166-1.properties")) {
            COUNTRIES.load(is);
        } catch (IOException e) {
            throw new TechnicalException("Unable to read country codes", e);
        }
    }

    /**
     * Checks whether the given country code is a valid ISO 3166-1 alpha-2 country code
     * @return
     */
    public static boolean isValidIsoCode(final String countryCode) {
        if(COUNTRY_CODE_SWITZERLAND.equals(countryCode)) {
            // CH will be the most used country code, thus quick validation step
            return true;
        } else if(countryCode == null || countryCode.length() != 2) {
            return false;
        }
        return COUNTRIES.containsKey(countryCode);
    }
}
