package ch.codeblock.qrinvoice.util;

import ch.codeblock.qrinvoice.QrInvoiceSpec;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class DecimalFormatFactory {
    public static DecimalFormat createQrCodeAmountFormat() {
        return new DecimalFormat(QrInvoiceSpec.AMOUNT_DECIMAL_FORMAT_QRCODE, createDecimalFormatSymbols());
    }

    public static DecimalFormat createPrintAmountFormat() {
        return new DecimalFormat(QrInvoiceSpec.AMOUNT_DECIMAL_FORMAT_PRINT, createDecimalFormatSymbols());
    }

    private static DecimalFormatSymbols createDecimalFormatSymbols() {
        DecimalFormatSymbols formatSymbols = new DecimalFormatSymbols(Locale.ENGLISH);
        formatSymbols.setDecimalSeparator(QrInvoiceSpec.AMOUNT_DECIMAL_FORMAT_DECIMAL_SEPARATOR);
        formatSymbols.setGroupingSeparator(QrInvoiceSpec.AMOUNT_DECIMAL_FORMAT_GROUPING_SEPARATOR);
        return formatSymbols;
    }
}
