package ch.codeblock.qrinvoice.util;

import java.util.regex.Pattern;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean isEmpty(final CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(final CharSequence cs) {
        return !isEmpty(cs);
    }

    public static String emptyStringAsNull(final String str) {
        if (str != null && str.isEmpty()) {
            return null;
        } else {
            return str;
        }
    }

    private static final Pattern NUMERIC_PATTERN = Pattern.compile("[-+]?\\d*\\.?\\d+");
    public static boolean isNumeric(String s) {
        return s != null && NUMERIC_PATTERN.matcher(s).matches();
    }


    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");
    public static String removeWhitespaces(final String ibanInput) {
        return WHITESPACE_PATTERN.matcher(ibanInput).replaceAll("");
    }
}
