/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice;

import ch.codeblock.qrinvoice.NotYetImplementedException;
import ch.codeblock.qrinvoice.OutputFormat;
import ch.codeblock.qrinvoice.QrInvoiceCodeCreator;
import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.SwissPaymentsCode;
import ch.codeblock.qrinvoice.model.TestdataFileRegistry;
import ch.codeblock.qrinvoice.model.mapper.SwissPaymentsCodeToModelMapper;
import ch.codeblock.qrinvoice.util.StringUtils;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class QrInvoiceCodeCreatorTests {
    private final String testFile;
    private final QrInvoice qrInvoice;

    @Parameterized.Parameters(name="Testfile: {0}")
    public static Collection<String> testFile() {
        return TestdataFileRegistry.data();
    }

    public QrInvoiceCodeCreatorTests(String testFile) {
        this.testFile = testFile;
        SwissPaymentsCode original = SwissPaymentsCode.parse((String)TestdataFileRegistry.getFileContent(testFile));
        SwissPaymentsCodeToModelMapper mapper = new SwissPaymentsCodeToModelMapper();
        this.qrInvoice = mapper.map(original);
    }

    @Test
    public void testQrInvoice() {
        byte[] png = QrInvoiceCodeCreator.create().qrInvoice(this.qrInvoice).desiredQrCodeSize(500).outputFormat(OutputFormat.PNG).createQrCode();
        Assert.assertNotNull((Object)png);
    }

    @Test
    public void testQrCode() {
        String swissPaymentsCode = QrInvoiceCodeCreator.create().qrInvoice(this.qrInvoice).desiredQrCodeSize(500).createSwissPaymentsCode();
        Assert.assertNotNull((Object)swissPaymentsCode);
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)swissPaymentsCode));
    }

    @Test(expected=NotYetImplementedException.class)
    public void testQrInvoiceUnsupportedOutputFormat() {
        QrInvoiceCodeCreator.create().qrInvoice(this.qrInvoice).desiredQrCodeSize(500).outputFormat(OutputFormat.PDF).createQrCode();
    }
}

