/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.model;

import ch.codeblock.qrinvoice.model.ParseException;
import ch.codeblock.qrinvoice.model.SwissPaymentsCode;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwissPaymentsCodeTest {
    private final Logger logger = LoggerFactory.getLogger(SwissPaymentsCodeTest.class);

    @Test
    public void testToQrCodeString() {
        SwissPaymentsCode swissPaymentsCode = new SwissPaymentsCode();
        swissPaymentsCode.setQrType("SPC");
        swissPaymentsCode.setAmt("1234.75");
        swissPaymentsCode.setReqdExctnDt("1988-04-03");
        this.logger.debug(swissPaymentsCode.toString());
        String spc = swissPaymentsCode.toSwissPaymentsCodeString();
        SwissPaymentsCode parsed = SwissPaymentsCode.parse((String)spc);
        this.logger.debug(parsed.toString());
        Assert.assertEquals((Object)swissPaymentsCode, (Object)parsed);
    }

    @Test
    public void testParse() {
        SwissPaymentsCode spc = SwissPaymentsCode.parse((String)"SPC");
        this.logger.debug(spc.toString());
        Assert.assertNotNull((Object)spc);
    }

    @Test
    public void testParseCrLf() {
        SwissPaymentsCode spc = SwissPaymentsCode.parse((String)"SPC\r\n0100\r\n1");
        this.logger.debug(spc.toString());
        this.lineFeedTestAsserts(spc);
    }

    @Test
    public void testParseLf() {
        SwissPaymentsCode spc = SwissPaymentsCode.parse((String)"SPC\n0100\n1");
        this.logger.debug(spc.toString());
        this.lineFeedTestAsserts(spc);
    }

    @Test
    public void testParseCr() {
        SwissPaymentsCode spc = SwissPaymentsCode.parse((String)"SPC\r0100\r1");
        this.logger.debug(spc.toString());
        this.lineFeedTestAsserts(spc);
    }

    private void lineFeedTestAsserts(SwissPaymentsCode spc) {
        Assert.assertNotNull((Object)spc);
        Assert.assertEquals((Object)"SPC", (Object)spc.getQrType());
        Assert.assertEquals((Object)"0100", (Object)spc.getVersion());
        Assert.assertEquals((Object)"1", (Object)spc.getCoding());
    }

    @Test(expected=ParseException.class)
    public void testParseNull() throws Exception {
        SwissPaymentsCode.parse(null);
    }
}

