/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.model.builder;

import ch.codeblock.qrinvoice.model.Creditor;
import ch.codeblock.qrinvoice.model.CreditorInformation;
import ch.codeblock.qrinvoice.model.Header;
import ch.codeblock.qrinvoice.model.PaymentAmountInformation;
import ch.codeblock.qrinvoice.model.PaymentReference;
import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.UltimateCreditor;
import ch.codeblock.qrinvoice.model.UltimateDebtor;
import ch.codeblock.qrinvoice.model.builder.QrInvoiceBuilder;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import org.junit.Assert;
import org.junit.Test;

public class QrInvoiceBuilderFullInfoTest {
    @Test
    public void createValidateSemiFluent() {
        this.validate(this.createSemiFluent());
    }

    @Test
    public void createValidateFluent() {
        this.validate(this.createFluent());
    }

    @Test
    public void verifyDifferentConstructionPathEquals() {
        QrInvoice fluent = this.createFluent();
        QrInvoice semiFluent = this.createSemiFluent();
        Assert.assertEquals((Object)fluent, (Object)semiFluent);
    }

    private void validate(QrInvoice qrInvoice) {
        Header header = qrInvoice.getHeader();
        Assert.assertEquals((Object)"SPC", (Object)header.getQrType());
        Assert.assertEquals((long)100L, (long)header.getVersion());
        Assert.assertEquals((long)1L, (long)header.getCodingType());
        PaymentAmountInformation paymentAmountInformation = qrInvoice.getPaymentAmountInformation();
        Assert.assertEquals((Object)BigDecimal.valueOf(1949.75), (Object)paymentAmountInformation.getAmount());
        Assert.assertEquals((Object)"CHF", (Object)paymentAmountInformation.getCurrency().getCurrencyCode());
        Assert.assertEquals((Object)LocalDate.of(2019, Month.OCTOBER, 31), (Object)paymentAmountInformation.getDate());
        CreditorInformation creditorInformation = qrInvoice.getCreditorInformation();
        Assert.assertEquals((Object)"CH44 3199 9123 0008 8901 2", (Object)creditorInformation.getIban());
        Creditor creditor = creditorInformation.getCreditor();
        Assert.assertEquals((Object)"Robert Schneider AG", (Object)creditor.getName());
        Assert.assertEquals((Object)"Rue du Lac", (Object)creditor.getStreetName());
        Assert.assertEquals((Object)"1268", (Object)creditor.getHouseNumber());
        Assert.assertEquals((Object)"2501", (Object)creditor.getPostalCode());
        Assert.assertEquals((Object)"Biel", (Object)creditor.getCity());
        Assert.assertEquals((Object)"CH", (Object)creditor.getCountry());
        UltimateCreditor ultimateCreditor = qrInvoice.getUltimateCreditor();
        Assert.assertEquals((Object)"Robert Schneider Services Switzerland AG", (Object)ultimateCreditor.getName());
        Assert.assertEquals((Object)"Rue du Lac", (Object)ultimateCreditor.getStreetName());
        Assert.assertEquals((Object)"1268/3/1", (Object)ultimateCreditor.getHouseNumber());
        Assert.assertEquals((Object)"2501", (Object)ultimateCreditor.getPostalCode());
        Assert.assertEquals((Object)"Biel", (Object)ultimateCreditor.getCity());
        Assert.assertEquals((Object)"CH", (Object)ultimateCreditor.getCountry());
        UltimateDebtor ultimateDebtor = qrInvoice.getUltimateDebtor();
        Assert.assertEquals((Object)"Pia-Maria Rutschmann-Schnyder", (Object)ultimateDebtor.getName());
        Assert.assertEquals((Object)"Grosse Marktgasse", (Object)ultimateDebtor.getStreetName());
        Assert.assertEquals((Object)"28", (Object)ultimateDebtor.getHouseNumber());
        Assert.assertEquals((Object)"9400", (Object)ultimateDebtor.getPostalCode());
        Assert.assertEquals((Object)"Rorschach", (Object)ultimateDebtor.getCity());
        Assert.assertEquals((Object)"CH", (Object)ultimateDebtor.getCountry());
        PaymentReference paymentReference = qrInvoice.getPaymentReference();
        Assert.assertEquals((Object)"SCOR", (Object)paymentReference.getReferenceType().getReferenceTypeCode());
        Assert.assertEquals((Object)"RF18539007547034", (Object)paymentReference.getReference());
        Assert.assertEquals((Object)"Instruction of 15.09.2019##S1/01/20170309/11/10201409/20/1400 0000/22/36958/30/CH106017086/40/1020/41/3010", (Object)paymentReference.getUnstructuredMessage());
        Assert.assertNull((Object)qrInvoice.getAlternativeSchemes());
    }

    private QrInvoice createSemiFluent() {
        QrInvoiceBuilder qrInvoiceBuilder = QrInvoiceBuilder.create().creditorIBAN("CH44 3199 9123 0008 8901 2");
        qrInvoiceBuilder.paymentAmountInformation().chf(1949.75).date(LocalDate.of(2019, Month.OCTOBER, 31));
        qrInvoiceBuilder.creditor().name("Robert Schneider AG").streetName("Rue du Lac").houseNumber("1268").postalCode("2501").city("Biel").country("CH");
        qrInvoiceBuilder.ultimateCreditor().name("Robert Schneider Services Switzerland AG").streetName("Rue du Lac").houseNumber("1268/3/1").postalCode("2501").city("Biel").country("CH");
        qrInvoiceBuilder.ultimateDebtor().name("Pia-Maria Rutschmann-Schnyder").streetName("Grosse Marktgasse").houseNumber("28").postalCode("9400").city("Rorschach").country("CH");
        qrInvoiceBuilder.paymentReference().creditorReference("RF18539007547034").unstructuredMessage("Instruction of 15.09.2019##S1/01/20170309/11/10201409/20/1400 0000/22/36958/30/CH106017086/40/1020/41/3010");
        qrInvoiceBuilder.alternativeSchemeParameters(null);
        return qrInvoiceBuilder.build();
    }

    private QrInvoice createFluent() {
        return QrInvoiceBuilder.create().creditorIBAN("CH44 3199 9123 0008 8901 2").paymentAmountInformation(p -> p.chf(1949.75).date(LocalDate.of(2019, Month.OCTOBER, 31))).creditor(c -> c.name("Robert Schneider AG").streetName("Rue du Lac").houseNumber("1268").postalCode("2501").city("Biel").country("CH")).ultimateCreditor(u -> u.name("Robert Schneider Services Switzerland AG").streetName("Rue du Lac").houseNumber("1268/3/1").postalCode("2501").city("Biel").country("CH")).ultimateDebtor(d -> d.name("Pia-Maria Rutschmann-Schnyder").streetName("Grosse Marktgasse").houseNumber("28").postalCode("9400").city("Rorschach").country("CH")).paymentReference(r -> r.creditorReference("RF18539007547034").unstructuredMessage("Instruction of 15.09.2019##S1/01/20170309/11/10201409/20/1400 0000/22/36958/30/CH106017086/40/1020/41/3010")).alternativeSchemeParameters(null).build();
    }

    private QrInvoice d() {
        QrInvoice qrInvoice = QrInvoiceBuilder.create().creditorIBAN("CH44 3199 9123 0008 8901 2").paymentAmountInformation(p -> p.chf(1949.75).date(LocalDate.of(2019, Month.OCTOBER, 31))).creditor(c -> c.name("Robert Schneider AG").streetName("Rue du Lac").houseNumber("1268").postalCode("2501").city("Biel").country("CH")).ultimateCreditor(u -> u.name("Robert Schneider Services Switzerland AG").streetName("Rue du Lac").houseNumber("1268/3/1").postalCode("2501").city("Biel").country("CH")).ultimateDebtor(d -> d.name("Pia-Maria Rutschmann-Schnyder").streetName("Grosse Marktgasse").houseNumber("28").postalCode("9400").city("Rorschach").country("CH")).paymentReference(r -> r.creditorReference("RF18539007547034").unstructuredMessage("Instruction of 15.09.2019##S1/01/20170309/11/10201409/20/1400 0000/22/36958/30/CH106017086/40/1020/41/3010")).alternativeSchemeParameters(null).build();
        return qrInvoice;
    }
}

