/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.model.builder;

import ch.codeblock.qrinvoice.model.Creditor;
import ch.codeblock.qrinvoice.model.CreditorInformation;
import ch.codeblock.qrinvoice.model.Header;
import ch.codeblock.qrinvoice.model.PaymentAmountInformation;
import ch.codeblock.qrinvoice.model.PaymentReference;
import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.UltimateCreditor;
import ch.codeblock.qrinvoice.model.UltimateDebtor;
import ch.codeblock.qrinvoice.model.builder.PaymentAmountInformationBuilder;
import ch.codeblock.qrinvoice.model.builder.QrInvoiceBuilder;
import org.junit.Assert;
import org.junit.Test;

public class QrInvoiceBuilderMinimalTest {
    @Test
    public void createValidateFluent() {
        this.validate(this.create());
    }

    private void validate(QrInvoice qrInvoice) {
        Header header = qrInvoice.getHeader();
        Assert.assertEquals((Object)"SPC", (Object)header.getQrType());
        Assert.assertEquals((long)100L, (long)header.getVersion());
        Assert.assertEquals((long)1L, (long)header.getCodingType());
        PaymentAmountInformation paymentAmountInformation = qrInvoice.getPaymentAmountInformation();
        Assert.assertNull((Object)paymentAmountInformation.getAmount());
        Assert.assertEquals((Object)"EUR", (Object)paymentAmountInformation.getCurrency().getCurrencyCode());
        Assert.assertNull((Object)paymentAmountInformation.getDate());
        CreditorInformation creditorInformation = qrInvoice.getCreditorInformation();
        Assert.assertEquals((Object)"CH3709000000304442225", (Object)creditorInformation.getIban());
        Creditor creditor = creditorInformation.getCreditor();
        Assert.assertEquals((Object)"Salvation Army Foundation Switzerland", (Object)creditor.getName());
        Assert.assertNull((Object)creditor.getStreetName());
        Assert.assertNull((Object)creditor.getHouseNumber());
        Assert.assertEquals((Object)"3000", (Object)creditor.getPostalCode());
        Assert.assertEquals((Object)"Bern", (Object)creditor.getCity());
        Assert.assertEquals((Object)"CH", (Object)creditor.getCountry());
        UltimateCreditor ultimateCreditor = qrInvoice.getUltimateCreditor();
        Assert.assertNull((Object)ultimateCreditor);
        UltimateDebtor ultimateDebtor = qrInvoice.getUltimateDebtor();
        Assert.assertNull((Object)ultimateDebtor);
        PaymentReference paymentReference = qrInvoice.getPaymentReference();
        Assert.assertEquals((Object)"NON", (Object)paymentReference.getReferenceType().getReferenceTypeCode());
        Assert.assertNull((Object)paymentReference.getReference());
        Assert.assertNull((Object)paymentReference.getUnstructuredMessage());
        Assert.assertNull((Object)qrInvoice.getAlternativeSchemes());
    }

    private QrInvoice create() {
        return QrInvoiceBuilder.create().creditorIBAN("CH3709000000304442225").paymentAmountInformation(PaymentAmountInformationBuilder::eur).creditor(c -> c.name("Salvation Army Foundation Switzerland").postalCode("3000").city("Bern").country("CH")).build();
    }
}

