/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.model.validation;

import ch.codeblock.qrinvoice.model.Creditor;
import ch.codeblock.qrinvoice.model.validation.AddressValidator;
import ch.codeblock.qrinvoice.model.validation.ValidationResult;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressValidatorTest {
    private final Logger logger = LoggerFactory.getLogger(AddressValidatorTest.class);
    private AddressValidator validator;
    private ValidationResult validationResult;

    @Before
    public void setup() {
        this.validator = new AddressValidator();
        this.validationResult = new ValidationResult();
    }

    @Test
    public void testValidate() {
        Creditor creditor = new Creditor();
        creditor.setName("Robert Schneider AG");
        creditor.setPostalCode("2501");
        creditor.setCity("Biel");
        creditor.setCountry("CH");
        this.validator.validate(creditor, this.validationResult);
        this.logger.info(this.validationResult.getValidationErrorSummary());
        Assert.assertTrue((boolean)this.validationResult.isEmpty());
    }

    @Test
    public void testInvalidNull() {
        Creditor creditor = new Creditor();
        creditor.setName(null);
        this.validator.validate(creditor, this.validationResult);
        this.logger.info(this.validationResult.getValidationErrorSummary());
        Assert.assertFalse((boolean)this.validationResult.isEmpty());
    }

    @Test
    public void testInvalidEmpty() {
        Creditor creditor = new Creditor();
        creditor.setName("");
        this.validator.validate(creditor, this.validationResult);
        this.logger.info(this.validationResult.getValidationErrorSummary());
        Assert.assertFalse((boolean)this.validationResult.isEmpty());
    }

    @Test
    public void testInvalidTooLong() {
        Creditor creditor = new Creditor();
        creditor.setName("This is a way too long company name that exceeds 70 characters by a 5 chars");
        this.validator.validate(creditor, this.validationResult);
        this.logger.info(this.validationResult.getValidationErrorSummary());
        Assert.assertFalse((boolean)this.validationResult.isEmpty());
    }

    @Test
    public void testValidate1() {
    }
}

