/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.model.validation;

import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.builder.QrInvoiceBuilder;
import ch.codeblock.qrinvoice.model.validation.QrInvoiceValidator;
import ch.codeblock.qrinvoice.model.validation.ValidationResult;
import java.time.LocalDate;
import java.time.Month;
import java.util.Currency;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrInvoiceValidatorTest {
    private final Logger logger = LoggerFactory.getLogger(QrInvoiceValidatorTest.class);
    private QrInvoiceValidator qrInvoiceValidator;

    @Before
    public void setUp() throws Exception {
        this.qrInvoiceValidator = new QrInvoiceValidator();
    }

    @Test
    public void testValid() throws Exception {
        QrInvoice qrInvoice = this.createValid();
        ValidationResult validationResult = this.qrInvoiceValidator.validate(qrInvoice);
        this.logger.info(validationResult.getValidationErrorSummary());
        Assert.assertFalse((boolean)validationResult.hasErrors());
    }

    @Test
    public void testInvalidCreditorName() throws Exception {
        QrInvoice qrInvoice = this.createValid();
        qrInvoice.getCreditorInformation().getCreditor().setName("this is invalid as it is just a too long string with more than 70 chars");
        qrInvoice.getCreditorInformation().setIban("non-valid-iban");
        ValidationResult validationResult = this.qrInvoiceValidator.validate(qrInvoice);
        this.logger.info(validationResult.getValidationErrorSummary());
        Assert.assertTrue((boolean)validationResult.hasErrors());
    }

    @Test
    public void testMissingCurrency() throws Exception {
        QrInvoice qrInvoice = this.createValid();
        qrInvoice.getPaymentAmountInformation().setCurrency(null);
        ValidationResult validationResult = this.qrInvoiceValidator.validate(qrInvoice);
        this.logger.info(validationResult.getValidationErrorSummary());
        Assert.assertTrue((boolean)validationResult.hasErrors());
    }

    @Test
    public void testUnsupportedCurrency() throws Exception {
        QrInvoice qrInvoice = this.createValid();
        qrInvoice.getPaymentAmountInformation().setCurrency(Currency.getInstance("JPY"));
        ValidationResult validationResult = this.qrInvoiceValidator.validate(qrInvoice);
        this.logger.info(validationResult.getValidationErrorSummary());
        Assert.assertTrue((boolean)validationResult.hasErrors());
    }

    private QrInvoice createValid() {
        return QrInvoiceBuilder.create().creditorIBAN("CH44 3199 9123 0008 8901 2").paymentAmountInformation(p -> p.chf(1949.75).date(LocalDate.of(2019, Month.OCTOBER, 31))).creditor(c -> c.name("Robert Schneider AG").streetName("Rue du Lac").houseNumber("1268").postalCode("2501").city("Biel").country("CH")).ultimateCreditor(u -> u.name("Robert Schneider Services Switzerland AG").streetName("Rue du Lac").houseNumber("1268/3/1").postalCode("2501").city("Biel").country("CH")).ultimateDebtor(d -> d.name("Pia-Maria Rutschmann-Schnyder").streetName("Grosse Marktgasse").houseNumber("28").postalCode("9400").city("Rorschach").country("CH")).paymentReference(r -> r.creditorReference("RF18539007547034").unstructuredMessage("Instruction of 15.09.2019##S1/01/20170309/11/10201409/20/1400 0000/22/36958/30/CH106017086/40/1020/41/3010")).alternativeSchemeParameters(null).build();
    }
}

