/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.model.validation;

import ch.codeblock.qrinvoice.model.validation.ValidationUtils;
import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;

public class ValidationUtilsTest {
    @Test
    public void testValidateLength() throws Exception {
        Assert.assertFalse((boolean)ValidationUtils.validateLength(null, (int)0, (int)10, (boolean)false));
        Assert.assertTrue((boolean)ValidationUtils.validateLength((CharSequence)"", (int)0, (int)10, (boolean)false));
        Assert.assertFalse((boolean)ValidationUtils.validateLength((CharSequence)"", (int)1, (int)10, (boolean)false));
        Assert.assertTrue((boolean)ValidationUtils.validateLength((CharSequence)"a", (int)1, (int)10, (boolean)false));
        Assert.assertTrue((boolean)ValidationUtils.validateLength((CharSequence)"abc", (int)1, (int)10, (boolean)false));
        Assert.assertTrue((boolean)ValidationUtils.validateLength((CharSequence)"abcdefghij", (int)1, (int)10, (boolean)false));
        Assert.assertFalse((boolean)ValidationUtils.validateLength((CharSequence)"abcdefghijk", (int)1, (int)10, (boolean)false));
    }

    @Test
    public void testValidateLengthOptional() throws Exception {
        Assert.assertTrue((boolean)ValidationUtils.validateLength(null, (int)0, (int)10, (boolean)true));
        Assert.assertTrue((boolean)ValidationUtils.validateLength((CharSequence)"", (int)0, (int)10, (boolean)true));
        Assert.assertTrue((boolean)ValidationUtils.validateLength((CharSequence)"", (int)1, (int)10, (boolean)true));
        Assert.assertTrue((boolean)ValidationUtils.validateLength((CharSequence)"a", (int)1, (int)10, (boolean)true));
        Assert.assertFalse((boolean)ValidationUtils.validateLength((CharSequence)"a", (int)2, (int)10, (boolean)true));
        Assert.assertTrue((boolean)ValidationUtils.validateLength((CharSequence)"abc", (int)1, (int)10, (boolean)true));
        Assert.assertTrue((boolean)ValidationUtils.validateLength((CharSequence)"abcdefghij", (int)1, (int)10, (boolean)true));
        Assert.assertFalse((boolean)ValidationUtils.validateLength((CharSequence)"abcdefghijk", (int)1, (int)10, (boolean)true));
    }

    @Test
    public void testValidateRange() throws Exception {
        Assert.assertTrue((boolean)ValidationUtils.validateRange((BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.TEN, (boolean)false));
        Assert.assertTrue((boolean)ValidationUtils.validateRange((BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.TEN, (boolean)false));
        Assert.assertTrue((boolean)ValidationUtils.validateRange((BigDecimal)BigDecimal.TEN, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.TEN, (boolean)false));
        Assert.assertFalse((boolean)ValidationUtils.validateRange(null, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.TEN, (boolean)false));
        Assert.assertTrue((boolean)ValidationUtils.validateRange(null, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.TEN, (boolean)true));
        Assert.assertFalse((boolean)ValidationUtils.validateRange((BigDecimal)BigDecimal.valueOf(-1.0), (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.TEN, (boolean)false));
        Assert.assertFalse((boolean)ValidationUtils.validateRange((BigDecimal)BigDecimal.valueOf(-1.0), (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.TEN, (boolean)true));
        Assert.assertFalse((boolean)ValidationUtils.validateRange((BigDecimal)BigDecimal.valueOf(11L), (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.TEN, (boolean)false));
        Assert.assertFalse((boolean)ValidationUtils.validateRange((BigDecimal)BigDecimal.valueOf(11L), (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.TEN, (boolean)true));
    }
}

