/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.util;

import ch.codeblock.qrinvoice.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class CollectionUtilsTest {
    @Test
    public void testIsEmptyWithEmptyCollection() {
        ArrayList coll = new ArrayList();
        Assert.assertEquals((Object)true, (Object)CollectionUtils.isEmpty(coll));
    }

    @Test
    public void testIsEmptyWithNonEmptyCollection() {
        ArrayList<String> coll = new ArrayList<String>();
        coll.add("item");
        Assert.assertEquals((Object)false, (Object)CollectionUtils.isEmpty(coll));
    }

    @Test
    public void testIsEmptyWithNull() {
        Collection coll = null;
        Assert.assertEquals((Object)true, (Object)CollectionUtils.isEmpty(coll));
    }

    @Test
    public void testIsNotEmptyWithEmptyCollection() {
        ArrayList coll = new ArrayList();
        Assert.assertEquals((Object)false, (Object)CollectionUtils.isNotEmpty(coll));
    }

    @Test
    public void testIsNotEmptyWithNonEmptyCollection() {
        ArrayList<String> coll = new ArrayList<String>();
        coll.add("item");
        Assert.assertEquals((Object)true, (Object)CollectionUtils.isNotEmpty(coll));
    }

    @Test
    public void testIsNotEmptyWithNull() {
        Collection coll = null;
        Assert.assertEquals((Object)false, (Object)CollectionUtils.isNotEmpty(coll));
    }

    @Test
    public void testSize_List() {
        ArrayList<String> list = null;
        Assert.assertEquals((long)0L, (long)CollectionUtils.size(list));
        list = new ArrayList<String>();
        Assert.assertEquals((long)0L, (long)CollectionUtils.size(list));
        list.add("a");
        Assert.assertEquals((long)1L, (long)CollectionUtils.size(list));
        list.add("b");
        Assert.assertEquals((long)2L, (long)CollectionUtils.size(list));
    }

    @Test
    public void testSize_Map() {
        HashMap<String, String> map = new HashMap<String, String>();
        Assert.assertEquals((long)0L, (long)CollectionUtils.size(map));
        map.put("1", "a");
        Assert.assertEquals((long)1L, (long)CollectionUtils.size(map));
        map.put("2", "b");
        Assert.assertEquals((long)2L, (long)CollectionUtils.size(map));
    }
}

