/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.util;

import ch.codeblock.qrinvoice.QrInvoiceSpec;
import ch.codeblock.qrinvoice.util.EncodingUtils;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncodingUtilsTest {
    private final Logger logger = LoggerFactory.getLogger(EncodingUtilsTest.class);

    @Test
    public void testValidLatinCharacters() {
        Assert.assertTrue((String)"Only latin characters are valid", (boolean)EncodingUtils.isValidEncoding((String)" - abcdefghijklmnopqerstufvwxyz\u00e4l\u00fc\u00e7123456780;\u00e9\u00e0\u00e8\u00c0\u00c9\u00c8\u00dc\u00c4\u00d6, !"));
        Assert.assertTrue((String)"", (boolean)EncodingUtils.isValidEncoding((String)"\u20ac\u0160\u0161\u017d\u017e\u0152\u0153\u0178"));
        Assert.assertTrue((String)"All latin characters are valid", (boolean)EncodingUtils.isValidEncoding((String)this.getAllLatin1CharactersExcludingControlCharacters()));
        Assert.assertFalse((String)"Even a single encoding stranger character is not permitted", (boolean)EncodingUtils.isValidEncoding((String)"abcdefg - \u0436 - hijkl"));
        Assert.assertFalse((String)"cyrillic characters are not valid", (boolean)EncodingUtils.isValidEncoding((String)"\u0436\u0444"));
        Assert.assertFalse((String)"japanese characters are not valid", (boolean)EncodingUtils.isValidEncoding((String)"\u3042\u307e"));
        Assert.assertFalse((String)"chinese characters are not valid", (boolean)EncodingUtils.isValidEncoding((String)"\u8bf6\u6bd4"));
        Assert.assertFalse((String)"korean characters are not valid", (boolean)EncodingUtils.isValidEncoding((String)"\u3142\u3141"));
        Assert.assertFalse((String)"arabic characters are not valid", (boolean)EncodingUtils.isValidEncoding((String)"\ufe90\ufeb6"));
    }

    @Test
    public void testLineBreakValidation() {
        Assert.assertTrue((String)"", (boolean)EncodingUtils.isValidEncoding((String)"\n"));
    }

    private String getAllLatin1CharactersExcludingControlCharacters() {
        Charset charset = QrInvoiceSpec.ENCODING;
        TreeMap<BigInteger, String> charsInEncodedOrder = new TreeMap<BigInteger, String>();
        for (int i = 0; i < 65535; ++i) {
            byte[] encoded;
            String decoded;
            String s;
            if (255 < i || 31 >= i || 127 <= i && i <= 159 || !(s = Character.toString((char)i)).equals(decoded = new String(encoded = s.getBytes(charset), charset))) continue;
            charsInEncodedOrder.put(new BigInteger(1, encoded), s);
        }
        String allCharactersString = charsInEncodedOrder.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.joining());
        this.logger.debug(allCharactersString);
        return allCharactersString;
    }
}

