/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.util;

import ch.codeblock.qrinvoice.util.IbanUtils;
import org.junit.Assert;
import org.junit.Test;

public class IbanUtilsTest {
    @Test
    public void testFormatIban() {
        Assert.assertEquals((Object)"CH39 0870 4016 0754 7300 7", (Object)IbanUtils.formatIban((String)"CH3908704016075473007"));
    }

    @Test
    public void testFormatIbanEmptyString() {
        Assert.assertEquals((Object)"", (Object)IbanUtils.formatIban((String)""));
    }

    @Test
    public void testFormatIbanBlankString() {
        Assert.assertEquals((Object)"", (Object)IbanUtils.formatIban((String)"    "));
    }

    @Test
    public void testFormatIbanNull() {
        Assert.assertEquals((Object)"", (Object)IbanUtils.formatIban(null));
    }

    @Test
    public void testValidChLiIban() {
        Assert.assertTrue((boolean)IbanUtils.isValidIBAN((String)"CH3908704016075473007", (boolean)true));
        Assert.assertTrue((boolean)IbanUtils.isValidIBAN((String)"CH39 0870 4016 0754 7300 7", (boolean)true));
        Assert.assertTrue((boolean)IbanUtils.isValidIBAN((String)"LI21 0881 0000 2324 013A A", (boolean)true));
    }

    @Test
    public void testValidForeignIbans() {
        Assert.assertTrue((boolean)IbanUtils.isValidIBAN((String)"BE68844010370034", (boolean)false));
        Assert.assertTrue((boolean)IbanUtils.isValidIBAN((String)"MT98MMEB44093000000009027293051", (boolean)false));
    }

    @Test
    public void testInvalidIban() {
        Assert.assertFalse((boolean)IbanUtils.isValidIBAN((String)"CH39", (boolean)false));
        Assert.assertFalse((boolean)IbanUtils.isValidIBAN((String)"CH3908704016075473001", (boolean)false));
        Assert.assertFalse((boolean)IbanUtils.isValidIBAN((String)"AR3908704016075473007", (boolean)false));
    }

    @Test
    public void testNull() {
        Assert.assertFalse((boolean)IbanUtils.isValidIBAN(null, (boolean)false));
    }

    @Test
    public void testEmptyString() {
        Assert.assertFalse((boolean)IbanUtils.isValidIBAN((String)"", (boolean)false));
    }

    @Test
    public void testLengths() {
        Assert.assertFalse((boolean)IbanUtils.isValidIBAN((String)"CH390870401607", (boolean)false));
        Assert.assertFalse((boolean)IbanUtils.isValidIBAN((String)"CH390870401607547300723432423234234", (boolean)false));
    }

    @Test
    public void testValidGermanIBAN() {
        Assert.assertTrue((boolean)IbanUtils.isValidIBAN((String)"DE89 3704 0044 0532 0130 00", (boolean)false));
    }

    @Test
    public void testValidGermanIBANButInvalidDueToCountryCode() {
        Assert.assertFalse((boolean)IbanUtils.isValidIBAN((String)"DE89 3704 0044 0532 0130 00", (boolean)true));
    }

    @Test
    public void testIsQrIBAN() throws Exception {
        Assert.assertTrue((boolean)IbanUtils.isQrIBAN((String)"CH44 3199 9123 0008 8901 2"));
        Assert.assertTrue((boolean)IbanUtils.isQrIBAN((String)"CH4431999123000889012"));
        Assert.assertFalse((boolean)IbanUtils.isQrIBAN((String)"CH31 8123 9000 0012 4568 9"));
    }
}

