/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.util;

import ch.codeblock.qrinvoice.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilsTest {
    @Test
    public void testIsEmpty() throws Exception {
        Assert.assertTrue((boolean)StringUtils.isEmpty(null));
        Assert.assertTrue((boolean)StringUtils.isEmpty((CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.isEmpty((CharSequence)" "));
        Assert.assertFalse((boolean)StringUtils.isEmpty((CharSequence)"a"));
    }

    @Test
    public void testIsNotEmpty() throws Exception {
        Assert.assertFalse((boolean)StringUtils.isNotEmpty(null));
        Assert.assertFalse((boolean)StringUtils.isNotEmpty((CharSequence)""));
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)" "));
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)"a"));
    }

    @Test
    public void testEmptyStringAsNull() throws Exception {
        Assert.assertNull((Object)StringUtils.emptyStringAsNull(null));
        Assert.assertNull((Object)StringUtils.emptyStringAsNull((String)""));
        Assert.assertEquals((Object)" ", (Object)StringUtils.emptyStringAsNull((String)" "));
        Assert.assertEquals((Object)"a", (Object)StringUtils.emptyStringAsNull((String)"a"));
    }

    @Test
    public void testIsNumeric() throws Exception {
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"-1456"));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"-1"));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"0"));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"1"));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"+1"));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"1234"));
        Assert.assertFalse((boolean)StringUtils.isNumeric((String)"1234d"));
        Assert.assertFalse((boolean)StringUtils.isNumeric((String)"a"));
        Assert.assertFalse((boolean)StringUtils.isNumeric((String)"ASDF234"));
        Assert.assertFalse((boolean)StringUtils.isNumeric(null));
    }
}

