/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice;

import ch.codeblock.qrinvoice.OutputFormat;
import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.mapper.ModelToSwissPaymentsCodeMapper;
import ch.codeblock.qrinvoice.qrcode.SwissQrCodeWriter;

public class QrInvoiceCodeCreator {
    private QrInvoice qrInvoice;
    private int desiredQrCodeSize = -1;
    private OutputFormat outputFormat;

    private QrInvoiceCodeCreator() {
    }

    public static QrInvoiceCodeCreator create() {
        return new QrInvoiceCodeCreator();
    }

    public String createSwissPaymentsCode() {
        return new ModelToSwissPaymentsCodeMapper().map(this.qrInvoice).toSwissPaymentsCodeString();
    }

    public QrInvoiceCodeCreator qrInvoice(QrInvoice qrInvoice) {
        this.qrInvoice = qrInvoice;
        return this;
    }

    public QrInvoiceCodeCreator outputFormat(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    public QrInvoiceCodeCreator desiredQrCodeSize(int desiredQrCodeSize) {
        this.desiredQrCodeSize = desiredQrCodeSize;
        return this;
    }

    public byte[] createQrCode() {
        if (this.outputFormat == null) {
            this.outputFormat = OutputFormat.PNG;
        }
        return new SwissQrCodeWriter().write(this.outputFormat, this.createSwissPaymentsCode(), this.desiredQrCodeSize);
    }
}

