/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.model;

import ch.codeblock.qrinvoice.model.ParseException;
import java.util.Objects;

public class PaymentReference {
    private ReferenceType referenceType;
    private String reference;
    private String unstructuredMessage;

    public ReferenceType getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(ReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getUnstructuredMessage() {
        return this.unstructuredMessage;
    }

    public void setUnstructuredMessage(String unstructuredMessage) {
        this.unstructuredMessage = unstructuredMessage;
    }

    public String toString() {
        return "PaymentReference{referenceType=" + (Object)((Object)this.referenceType) + ", reference='" + this.reference + '\'' + ", unstructuredMessage='" + this.unstructuredMessage + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentReference that = (PaymentReference)o;
        return this.referenceType == that.referenceType && Objects.equals(this.reference, that.reference) && Objects.equals(this.unstructuredMessage, that.unstructuredMessage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.referenceType, this.reference, this.unstructuredMessage});
    }

    public static enum ReferenceType {
        QR_REFERENCE("QRR"),
        CREDITOR_REFERENCE("SCOR"),
        WITHOUT_REFERENCE("NON");

        private final String referenceTypeCode;

        private ReferenceType(String referenceTypeCode) {
            this.referenceTypeCode = referenceTypeCode;
        }

        public String getReferenceTypeCode() {
            return this.referenceTypeCode;
        }

        public static ReferenceType parse(String referenceTypeCode) {
            for (ReferenceType referenceType : ReferenceType.values()) {
                if (!referenceType.getReferenceTypeCode().equals(referenceTypeCode)) continue;
                return referenceType;
            }
            throw new ParseException("Invalid reference type '" + referenceTypeCode + "' given");
        }

        public String toString() {
            return "ReferenceType{referenceTypeCode='" + this.referenceTypeCode + '\'' + "} " + super.toString();
        }
    }
}

