/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.model.builder;

import ch.codeblock.qrinvoice.model.PaymentReference;

public final class PaymentReferenceBuilder {
    private PaymentReference.ReferenceType referenceType;
    private String reference;
    private String unstructuredMessage;

    private PaymentReferenceBuilder() {
    }

    public static PaymentReferenceBuilder create() {
        return new PaymentReferenceBuilder();
    }

    public PaymentReferenceBuilder referenceType(PaymentReference.ReferenceType referenceType) {
        this.referenceType = referenceType;
        return this;
    }

    public PaymentReferenceBuilder reference(String reference) {
        this.reference = reference;
        return this;
    }

    public PaymentReferenceBuilder unstructuredMessage(String unstructuredMessage) {
        this.unstructuredMessage = unstructuredMessage;
        return this;
    }

    public PaymentReferenceBuilder qrReference(String reference) {
        return this.referenceType(PaymentReference.ReferenceType.QR_REFERENCE).reference(reference);
    }

    public PaymentReferenceBuilder creditorReference(String reference) {
        return this.referenceType(PaymentReference.ReferenceType.CREDITOR_REFERENCE).reference(reference);
    }

    public PaymentReferenceBuilder withoutReference(String reference) {
        return this.referenceType(PaymentReference.ReferenceType.WITHOUT_REFERENCE);
    }

    public PaymentReference build() {
        if (this.referenceType == null) {
            this.referenceType = PaymentReference.ReferenceType.WITHOUT_REFERENCE;
        }
        PaymentReference paymentReference = new PaymentReference();
        paymentReference.setReferenceType(this.referenceType);
        paymentReference.setReference(this.reference);
        paymentReference.setUnstructuredMessage(this.unstructuredMessage);
        return paymentReference;
    }
}

