/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.model.mapper;

import ch.codeblock.qrinvoice.model.AlternativeSchemes;
import ch.codeblock.qrinvoice.model.Creditor;
import ch.codeblock.qrinvoice.model.CreditorInformation;
import ch.codeblock.qrinvoice.model.Header;
import ch.codeblock.qrinvoice.model.PaymentAmountInformation;
import ch.codeblock.qrinvoice.model.PaymentReference;
import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.SwissPaymentsCode;
import ch.codeblock.qrinvoice.model.UltimateCreditor;
import ch.codeblock.qrinvoice.model.UltimateDebtor;
import ch.codeblock.qrinvoice.util.DecimalFormatFactory;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Currency;

public class SwissPaymentsCodeToModelMapper {
    public QrInvoice map(SwissPaymentsCode spc) {
        QrInvoice qrInvoice = new QrInvoice();
        qrInvoice.setHeader(this.mapHeader(spc));
        qrInvoice.setCreditorInformation(this.mapCreditorInformation(spc));
        qrInvoice.setUltimateCreditor(this.mapUltimateCreditor(spc));
        qrInvoice.setPaymentAmountInformation(this.mapPaymentAmountInformation(spc));
        qrInvoice.setUltimateDebtor(this.mapUltimateDebtor(spc));
        qrInvoice.setPaymentReference(this.mapPaymentReference(spc));
        qrInvoice.setAlternativeSchemes(this.mapAlternativeSchemes(spc));
        return qrInvoice;
    }

    private UltimateDebtor mapUltimateDebtor(SwissPaymentsCode spc) {
        UltimateDebtor ultimateDebtor = new UltimateDebtor();
        ultimateDebtor.setName(spc.getUdName());
        ultimateDebtor.setStreetName(spc.getUdStrtNm());
        ultimateDebtor.setHouseNumber(spc.getUdBldgNb());
        ultimateDebtor.setPostalCode(spc.getUdPstCd());
        ultimateDebtor.setCity(spc.getUdTwnNm());
        ultimateDebtor.setCountry(spc.getUdCtry());
        return ultimateDebtor;
    }

    private Header mapHeader(SwissPaymentsCode spc) {
        Header header = new Header();
        header.setQrType(spc.getQrType());
        header.setVersion(Short.parseShort(spc.getVersion()));
        header.setCodingType(Byte.parseByte(spc.getCoding()));
        return header;
    }

    private CreditorInformation mapCreditorInformation(SwissPaymentsCode spc) {
        CreditorInformation creditorInformation = new CreditorInformation();
        creditorInformation.setIban(spc.getIban());
        creditorInformation.setCreditor(this.mapCreditor(spc));
        return creditorInformation;
    }

    private Creditor mapCreditor(SwissPaymentsCode spc) {
        Creditor creditor = new Creditor();
        creditor.setName(spc.getCrName());
        creditor.setStreetName(spc.getCrStrtNm());
        creditor.setHouseNumber(spc.getCrBldgNb());
        creditor.setPostalCode(spc.getCrPstCd());
        creditor.setCity(spc.getCrTwnNm());
        creditor.setCountry(spc.getCrCtry());
        return creditor;
    }

    private UltimateCreditor mapUltimateCreditor(SwissPaymentsCode spc) {
        UltimateCreditor ultimateCreditor = new UltimateCreditor();
        ultimateCreditor.setName(spc.getUcrName());
        ultimateCreditor.setStreetName(spc.getUcrStrtNm());
        ultimateCreditor.setHouseNumber(spc.getUcrBldgNb());
        ultimateCreditor.setPostalCode(spc.getUcrPstCd());
        ultimateCreditor.setCity(spc.getUcrTwnNm());
        ultimateCreditor.setCountry(spc.getUcrCtry());
        return ultimateCreditor;
    }

    private PaymentReference mapPaymentReference(SwissPaymentsCode spc) {
        PaymentReference paymentReference = new PaymentReference();
        paymentReference.setReferenceType(PaymentReference.ReferenceType.parse(spc.getTp()));
        paymentReference.setReference(spc.getRef());
        paymentReference.setUnstructuredMessage(spc.getUstrd());
        return paymentReference;
    }

    private PaymentAmountInformation mapPaymentAmountInformation(SwissPaymentsCode spc) {
        PaymentAmountInformation paymentAmountInformation = new PaymentAmountInformation();
        String amt = spc.getAmt();
        if (amt != null) {
            DecimalFormat decimalFormat = DecimalFormatFactory.createQrCodeAmountFormat();
            decimalFormat.setParseBigDecimal(true);
            paymentAmountInformation.setAmount((BigDecimal)decimalFormat.parseObject(amt, new ParsePosition(0)));
        } else {
            paymentAmountInformation.setAmount(null);
        }
        paymentAmountInformation.setCurrency(Currency.getInstance(spc.getCcy()));
        String date = spc.getReqdExctnDt();
        if (date != null) {
            paymentAmountInformation.setDate(LocalDate.parse(date, DateTimeFormatter.ISO_DATE));
        } else {
            paymentAmountInformation.setDate(null);
        }
        return paymentAmountInformation;
    }

    private AlternativeSchemes mapAlternativeSchemes(SwissPaymentsCode spc) {
        AlternativeSchemes alternativeSchemes = new AlternativeSchemes();
        alternativeSchemes.setAlternativeSchemeParameters(spc.getAltPmts());
        return alternativeSchemes;
    }
}

