/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.model.util;

import ch.codeblock.qrinvoice.model.interfaces.Address;
import ch.codeblock.qrinvoice.util.StringUtils;

public class AddressUtils {
    public static boolean isEmpty(Address address) {
        return StringUtils.isEmpty(address.getName()) && StringUtils.isEmpty(address.getStreetName()) && StringUtils.isEmpty(address.getHouseNumber()) && StringUtils.isEmpty(address.getPostalCode()) && StringUtils.isEmpty(address.getCity()) && StringUtils.isEmpty(address.getCountry());
    }

    public static String toAddress(Address address) {
        if (address == null || address.isEmpty()) {
            return null;
        }
        return AddressUtils.toAddress(address.getName(), address.getStreetName(), address.getHouseNumber(), address.getCountry(), address.getPostalCode(), address.getCity());
    }

    private static String toAddress(String name, String streetName, String houseNumber, String country, String postalCode, String city) {
        boolean hasName = StringUtils.isNotEmpty(name);
        boolean hasStreetName = StringUtils.isNotEmpty(streetName);
        boolean hasHouseNumber = StringUtils.isNotEmpty(houseNumber);
        boolean hasCountry = StringUtils.isNotEmpty(country);
        boolean hasPostalCode = StringUtils.isNotEmpty(postalCode);
        boolean hasCity = StringUtils.isNotEmpty(city);
        boolean line1 = hasName;
        boolean line2 = hasStreetName || hasHouseNumber;
        boolean line3 = hasCountry || hasPostalCode || hasCity;
        StringBuilder sb = new StringBuilder();
        if (line1) {
            sb.append(name);
        }
        if (line1 && (line2 || line3)) {
            sb.append("\n");
        }
        if (line2) {
            if (hasStreetName) {
                sb.append(streetName);
            }
            if (hasStreetName && hasHouseNumber) {
                sb.append(" ");
            }
            if (hasHouseNumber) {
                sb.append(houseNumber);
            }
        }
        if (line2 && line3) {
            sb.append("\n");
        }
        if (line3) {
            if (hasCountry) {
                sb.append(country);
            }
            if (hasCountry && hasPostalCode) {
                sb.append("-");
            }
            if (hasPostalCode) {
                sb.append(postalCode);
            }
            if (hasPostalCode && hasCity) {
                sb.append(" ");
            }
            if (hasCity) {
                sb.append(city);
            }
        }
        return sb.toString();
    }
}

