/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.model.validation;

import ch.codeblock.qrinvoice.model.Creditor;
import ch.codeblock.qrinvoice.model.UltimateCreditor;
import ch.codeblock.qrinvoice.model.UltimateDebtor;
import ch.codeblock.qrinvoice.model.interfaces.Address;
import ch.codeblock.qrinvoice.model.validation.ValidationResult;
import ch.codeblock.qrinvoice.model.validation.ValidationUtils;
import ch.codeblock.qrinvoice.util.CountryUtils;

public class AddressValidator {
    public void validate(Creditor creditor, ValidationResult result) {
        this.validateAddress("creditorinformation.creditor", creditor, true, result);
    }

    public void validate(UltimateCreditor ultimateCreditor, ValidationResult result) {
        this.validateAddress("ultimateCreditor", ultimateCreditor, false, result);
    }

    public void validate(UltimateDebtor ultimateDebtor, ValidationResult result) {
        this.validateAddress("ultimateDebtor", ultimateDebtor, false, result);
    }

    private void validateAddress(String baseDataPath, Address address, boolean mandatoryGroup, ValidationResult result) {
        if (address == null) {
            if (mandatoryGroup) {
                result.addError(baseDataPath, null, "validation.error.address.group", new String[0]);
            }
            return;
        }
        ValidationUtils.validateLength((CharSequence)address.getName(), 1, 70, value -> result.addError(baseDataPath, "name", value, "validation.error.address.name"));
        ValidationUtils.validateOptionalLength(address.getStreetName(), 1, 70, value -> result.addError(baseDataPath, "streetName", value, "validation.error.address.streetName"));
        ValidationUtils.validateOptionalLength(address.getHouseNumber(), 1, 16, value -> result.addError(baseDataPath, "houseNumber", value, "validation.error.address.houseNumber"));
        ValidationUtils.validateLength((CharSequence)address.getPostalCode(), 1, 16, value -> result.addError(baseDataPath, "postalCode", value, "validation.error.address.postalCode"));
        ValidationUtils.validateLength((CharSequence)address.getCity(), 1, 35, value -> result.addError(baseDataPath, "city", value, "validation.error.address.city"));
        ValidationUtils.validateTrue(address.getCountry(), CountryUtils.isValidIsoCode(address.getCountry()), value -> result.addError(baseDataPath, "country", value, "validation.error.address.country"));
        ValidationUtils.validateCharacters(address.getName(), value -> result.addError(baseDataPath, "name", value, "validation.error.invalidCharacters"));
        ValidationUtils.validateCharacters(address.getStreetName(), value -> result.addError(baseDataPath, "streetName", value, "validation.error.invalidCharacters"));
        ValidationUtils.validateCharacters(address.getHouseNumber(), value -> result.addError(baseDataPath, "houseNumber", value, "validation.error.invalidCharacters"));
        ValidationUtils.validateCharacters(address.getPostalCode(), value -> result.addError(baseDataPath, "postalCode", value, "validation.error.invalidCharacters"));
        ValidationUtils.validateCharacters(address.getCity(), value -> result.addError(baseDataPath, "city", value, "validation.error.invalidCharacters"));
    }
}

