/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.model.validation;

import ch.codeblock.qrinvoice.NotYetImplementedException;
import ch.codeblock.qrinvoice.QrInvoiceSpec;
import ch.codeblock.qrinvoice.model.AlternativeSchemes;
import ch.codeblock.qrinvoice.model.CreditorInformation;
import ch.codeblock.qrinvoice.model.Header;
import ch.codeblock.qrinvoice.model.PaymentAmountInformation;
import ch.codeblock.qrinvoice.model.PaymentReference;
import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.UltimateCreditor;
import ch.codeblock.qrinvoice.model.UltimateDebtor;
import ch.codeblock.qrinvoice.model.validation.AddressValidator;
import ch.codeblock.qrinvoice.model.validation.ValidationResult;
import ch.codeblock.qrinvoice.model.validation.ValidationUtils;
import ch.codeblock.qrinvoice.util.CollectionUtils;
import ch.codeblock.qrinvoice.util.CreditorReferenceUtils;
import ch.codeblock.qrinvoice.util.IbanUtils;
import ch.codeblock.qrinvoice.util.QRReferenceUtils;
import java.math.BigDecimal;
import java.util.Currency;
import java.util.List;

public class QrInvoiceValidator {
    private final AddressValidator addressValidator = new AddressValidator();

    public static QrInvoiceValidator create() {
        return new QrInvoiceValidator();
    }

    public ValidationResult validate(QrInvoice qrInvoice) {
        ValidationResult validationResult = new ValidationResult();
        this.validate(qrInvoice.getHeader(), validationResult);
        this.validate(qrInvoice.getCreditorInformation(), validationResult);
        this.validate(qrInvoice.getUltimateCreditor(), validationResult);
        this.validate(qrInvoice.getUltimateDebtor(), validationResult);
        this.validate(qrInvoice.getPaymentAmountInformation(), validationResult);
        this.validate(qrInvoice.getPaymentReference(), validationResult);
        this.validate(qrInvoice.getAlternativeSchemes(), validationResult);
        this.validateCrossDependentElements(qrInvoice, validationResult);
        return validationResult;
    }

    private void validate(Header header, ValidationResult result) {
        byte codingType = header.getCodingType();
        ValidationUtils.validateTrue(codingType, codingType == 1, value -> result.addError("header", "codingType", codingType, "validation.error.codingType"));
        short version = header.getVersion();
        ValidationUtils.validateTrue(version, version == Short.parseShort("0100"), value -> result.addError("header", "version", version, "validation.error.version"));
        String qrType = header.getQrType();
        ValidationUtils.validateTrue(qrType, "SPC".equals(qrType), value -> result.addError("header", "qrType", qrType, "validation.error.qrType"));
    }

    private void validate(CreditorInformation creditorInformation, ValidationResult result) {
        this.addressValidator.validate(creditorInformation.getCreditor(), result);
        String iban = creditorInformation.getIban();
        ValidationUtils.validateTrue(iban, IbanUtils.isValidIBAN(iban, true), value -> result.addError("creditorInformation", "iban", value, "validation.error.iban"));
    }

    private void validate(UltimateCreditor ultimateCreditor, ValidationResult result) {
        this.addressValidator.validate(ultimateCreditor, result);
    }

    private void validate(UltimateDebtor ultimateDebtor, ValidationResult result) {
        this.addressValidator.validate(ultimateDebtor, result);
    }

    private void validate(PaymentAmountInformation paymentAmountInformation, ValidationResult result) {
        BigDecimal amount = paymentAmountInformation.getAmount();
        if (amount != null) {
            ValidationUtils.validateRange(amount, QrInvoiceSpec.AMOUNT_MIN, QrInvoiceSpec.AMOUNT_MAX, value -> result.addError("paymentAmountInformation", "amount", amount, "validation.error.amount"));
        }
        Currency currency = paymentAmountInformation.getCurrency();
        ValidationUtils.validateTrue(currency, QrInvoiceSpec.SUPPORTED_CURRENCIES.contains(currency), value -> result.addError("paymentAmountInformation", "currency", value, "validation.error.currency"));
    }

    private void validate(PaymentReference paymentReference, ValidationResult result) {
        PaymentReference.ReferenceType referenceType;
        ValidationUtils.validateTrue(referenceType, (referenceType = paymentReference.getReferenceType()) != null, value -> result.addError("paymentReference", "referenceType", value, "validation.error.referenceType"));
        String reference = paymentReference.getReference();
        ValidationUtils.validateCharacters(reference, value -> result.addError("paymentReference", "reference", value, "validation.error.invalidCharacters"));
        if (referenceType != null) {
            switch (referenceType) {
                case QR_REFERENCE: {
                    ValidationUtils.validateTrue(reference, QRReferenceUtils.isValid(reference), value -> result.addError("paymentReference", "reference", value, "validation.error.reference", "validation.error.reference.QRR"));
                    break;
                }
                case CREDITOR_REFERENCE: {
                    ValidationUtils.validateTrue(reference, CreditorReferenceUtils.isValid(reference), value -> result.addError("paymentReference", "reference", value, "validation.error.reference", "validation.error.reference.SCOR"));
                    break;
                }
                case WITHOUT_REFERENCE: {
                    ValidationUtils.validateEmpty(reference, value -> result.addError("paymentReference", "reference", value, "validation.error.reference", "validation.error.reference.NON"));
                    break;
                }
                default: {
                    throw new NotYetImplementedException("ReferenceType '" + reference + "' is not yet implemented");
                }
            }
        }
        String unstructuredMessage = paymentReference.getUnstructuredMessage();
        ValidationUtils.validateOptionalLength(unstructuredMessage, 0, 140, value -> result.addError("paymentReference", "unstructuredMessage", value, "validation.error.paymentReference.unstructuredMessage"));
        ValidationUtils.validateCharacters(unstructuredMessage, value -> result.addError("paymentReference", "unstructuredMessage", value, "validation.error.invalidCharacters"));
    }

    private void validate(AlternativeSchemes alternativeSchemes, ValidationResult result) {
        if (alternativeSchemes != null) {
            List<String> alternativeSchemeParameters = alternativeSchemes.getAlternativeSchemeParameters();
            int size = CollectionUtils.size(alternativeSchemeParameters);
            if (size > 2) {
                result.addError("alternativeSchemes", "alternativeSchemeParameters", size, "validation.error.alternativeSchemes.alternativeSchemeParameters.size");
            }
            if (size > 0) {
                for (String param : alternativeSchemeParameters) {
                    ValidationUtils.validateOptionalLength(param, 0, 100, value -> result.addError("alternativeSchemes", "alternativeSchemeParameters", value, "validation.error.alternativeSchemes.alternativeSchemeParameter.length"));
                    ValidationUtils.validateCharacters(param, value -> result.addError("alternativeSchemes", "alternativeSchemeParameters", value, "validation.error.invalidCharacters"));
                }
            }
        }
    }

    private void validateCrossDependentElements(QrInvoice qrInvoice, ValidationResult result) {
        String iban = qrInvoice.getCreditorInformation().getIban();
        if (IbanUtils.isQrIBAN(iban)) {
            PaymentReference.ReferenceType referenceType = qrInvoice.getPaymentReference().getReferenceType();
            if (referenceType != null) {
                switch (referenceType) {
                    case QR_REFERENCE: 
                    case CREDITOR_REFERENCE: {
                        return;
                    }
                }
            }
            result.addError("paymentReference", "referenceType", referenceType, "validation.error.referenceType.qrIban");
        }
    }
}

