/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.model.validation;

import ch.codeblock.qrinvoice.model.validation.ValidationException;
import ch.codeblock.qrinvoice.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.regex.Pattern;

public class ValidationResult {
    private static final Pattern LINE_BREAK_PATTERN = Pattern.compile("\\r\\n?|\\n");
    private List<ValidationError> errors;

    public <T> void addError(String parentDataPath, String dataPath, T value, String ... errorMsgKeys) {
        String completeDataPath = dataPath != null ? parentDataPath + '.' + dataPath : parentDataPath;
        this.addError(new ValidationError<T>(completeDataPath, value, errorMsgKeys));
    }

    private void addError(ValidationError error) {
        if (this.errors == null) {
            this.errors = new ArrayList<ValidationError>();
        }
        this.errors.add(error);
    }

    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.errors);
    }

    public boolean hasErrors() {
        return !this.isEmpty();
    }

    public void throwExceptionOnErrors() throws ValidationException {
        if (this.hasErrors()) {
            throw new ValidationException(this);
        }
    }

    public List<ValidationError> getErrors() {
        return this.errors != null ? this.errors : Collections.emptyList();
    }

    public String getValidationErrorSummary() {
        if (this.hasErrors()) {
            StringBuilder sb = new StringBuilder();
            sb.append("QrInvoice has validation errors:");
            sb.append(System.lineSeparator());
            ResourceBundle labels = ResourceBundle.getBundle("qrinvoice", Locale.ENGLISH);
            int errorNr = 1;
            for (ValidationError error : this.errors) {
                if (errorNr > 1) {
                    sb.append(System.lineSeparator());
                }
                sb.append(errorNr++).append(". ").append(error.getDataPath()).append('\'');
                sb.append(" has invalid value '").append(error.getValue()).append("'");
                Arrays.stream(error.getErrorMsgKeys()).map(labels::getString).map(LINE_BREAK_PATTERN::split).flatMap(Arrays::stream).forEach(s -> sb.append(System.lineSeparator()).append("    =>").append(" ").append((String)s));
            }
            return sb.toString();
        }
        return "No validation errors";
    }

    public String toString() {
        return "ValidationResult{errors=" + this.errors + '}';
    }

    public class ValidationError<T> {
        private final String dataPath;
        private final T value;
        private final String[] errorMsgKeys;

        public ValidationError(String dataPath, T value, String ... errorMsgKeys) {
            this.dataPath = dataPath;
            this.value = value;
            this.errorMsgKeys = errorMsgKeys;
        }

        public String getDataPath() {
            return this.dataPath;
        }

        public T getValue() {
            return this.value;
        }

        public String[] getErrorMsgKeys() {
            return this.errorMsgKeys;
        }

        public String toString() {
            return "ValidationError{dataPath='" + this.dataPath + '\'' + ", value=" + this.value + ", errorMsgKeys='" + Arrays.toString(this.errorMsgKeys) + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValidationError that = (ValidationError)o;
            return Objects.equals(this.dataPath, that.dataPath) && Objects.equals(this.value, that.value) && Arrays.equals(this.errorMsgKeys, that.errorMsgKeys);
        }

        public int hashCode() {
            return Objects.hash(this.dataPath, this.value, this.errorMsgKeys);
        }
    }
}

